package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

import com.maila.biz.center.api.dto.DuibaBlacklistDto;

/**
 * 麦啦管理员后台兑吧公共应用黑名单接口
 * @Author zhanghuifeng
 * @Date 15:09 2017/2/20
 */
@AdvancedFeignClient
public interface RemoteDuibaBlacklistBackendService {

	/**
	 * 新增
	 * @param duibaAppIds  兑吧应用ID集合
	 * @param relationId   来源ID
	 * @param relationType 类型
	 * @return
	 */
	DubboResult<Boolean> batchInsertDuibaBlacklist(List<Long> duibaAppIds, Long relationId, Integer relationType);

	/**
	 * 关闭兑吧公共应用黑名单
	 * @param relationId   来源ID
	 * @param relationType 类型
	 * @param appId
	 * @param switchStatus
	 * @return
	 */
	DubboResult<Boolean> duibaBlacklistSwitch(Long appId, int switchStatus, Long relationId, Integer relationType);

	/**
	 * 分页获取兑吧公共应用黑名单
	 * @param relationId   来源ID
	 * @param relationType 类型
	 * @param offset
	 * @param pageSize
	 * @return
	 */
	DubboResult<List<DuibaBlacklistDto>> findBlacklistByRelationPage(Long relationId, Integer relationType, Integer offset, Integer pageSize);

	/**
	 * 分页获取兑吧公共应用黑名单数
	 * @param relationId   来源ID
	 * @param relationType 类型
	 * @return
	 */
	DubboResult<Long> countFindBlacklistByRelationPage(Long relationId, Integer relationType);

	/**
	 *移除单个兑吧黑名单应用
	 * @param id  黑名单主键ID
	 * @return
	 */
	DubboResult<Boolean> deleteSingleBlacklistById(Long id);

	/**
	 * 批量开启关闭兑吧公共应用下商品的黑名单状态
	 *
	 * @param switchStatus 开关状态
	 * @param goodsIds     商品id集合
	 * @return DubboResult<Boolean>
	 */
	DubboResult<Boolean> batchDuibaGoodsBlacklistSwitch(boolean switchStatus, List<Long> goodsIds);

	/**
	 * 批量增加商品黑名单
	 * @param duibaAppIds 兑吧appId集合
	 * @param goodsIds   商品id集合
	 * @return DubboResult<Boolean>
	 */
	DubboResult<Boolean> batchDuibaGoodsBlackInsert(List<Long> duibaAppIds,List<Long> goodsIds);
}
