package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.DuibaBlacklistDto;
import com.maila.biz.center.api.enums.DuibaBlacklistRelationType;

import java.util.List;

/**
 * 功能描述:兑吧公共应用黑名单
 *
 * @author sunchangji
 * @date 2017/3/15
 */
@AdvancedFeignClient
public interface RemoteDuibaBlacklistService {

	/**
	 * 查询对应类型下黑名单的relationId集合
	 *
	 * @param relationTypeEnum 关联类型枚举
	 * @param duibaAppId      兑吧appId
	 * @return List<Long>
	 */
	DubboResult<List<Long>> findRelationIdsByDuibaAppId(DuibaBlacklistRelationType relationTypeEnum, Long duibaAppId);

	/**
	 *
	 * @param type
	 * @param relationIds
	 * @param duibaAppId
     * @return
     */
	DubboResult<List<DuibaBlacklistDto>> find4DuibaAppCheck(DuibaBlacklistRelationType type, List<Long> relationIds, Long duibaAppId);
}
