package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.maila.biz.center.api.dto.BusinessMsgDto;
import com.maila.biz.center.api.dto.MailaAppGoodsDto;
import com.maila.biz.center.api.dto.MailaAppGoodsOrSpecialDto;
import com.maila.biz.center.api.param.MailaAppGoodsQryParam;

import java.util.Date;
import java.util.List;


/**
 * 为管理员后台提供商品虚拟库
 *
 * @Author zhanghuifeng
 * @Date 14:21 2016/12/22
 */
@AdvancedFeignClient
public interface RemoteMailaAppGoodsBackendService {

    /**
     * 根据应用id和商品id获取虚拟库商品(分页)
     *
     * @param mailaAppGoodsQryParam
     * @return
     */
    DubboResult<List<MailaAppGoodsDto>> findAppGoodsPage(MailaAppGoodsQryParam mailaAppGoodsQryParam);

    /**
     * 根据应用id和商品id获取虚拟库商品数量(分页)
     *
     * @param mailaAppGoodsQryParam
     * @return
     */
    DubboResult<Long> count4findAppGoodsPage(MailaAppGoodsQryParam mailaAppGoodsQryParam);

    /**
     * 根据应用id、商品id删除商品虚拟库
     *
     * @param appId   应用id
     * @param goodsId 商品goodsId
     * @return
     */
    DubboResult<Boolean> deleteAppGoods(Long appId, Long goodsId);

    /**
     * 批量删除虚拟库商品
     * @param appId 应用id
     * @param goodsIds 商品goodsId 以","分隔
     * @return
     */
    DubboResult<Boolean> batchDeleteAppGoods(Long appId, String goodsIds);

    /**
     * 更新
     *
     * @param mailaAppGoodsDto
     * @return
     */
    DubboResult<BusinessMsgDto> update(MailaAppGoodsDto mailaAppGoodsDto);

    /**
     * 单个虚拟库商品进多个tab
     *
     * @param appId   应用id
     * @param goodsId 商品goodsId
     * @param tabIds  tabId集合
     * @return
     */
    DubboResult<Boolean> pushSingleAppGoodsToTabs(Long appId, Long goodsId, List<Long> tabIds);

    /**
     * 多个虚拟库商品进多个tab
     *
     * @param appId    应用id
     * @param goodsIds 商品goodsId集
     * @param tabIds   tabId集合
     * @return
     */
    DubboResult<Boolean> pushMultiAppGoodsToTabs(Long appId, List<Long> goodsIds, List<Long> tabIds);


    /**
     * 根据应用id,商品id或商品标题查询商品信息
     *
     * @param appId    应用id
     * @param nameOrId 商品id或商品标题
     * @return
     */
    DubboResult<List<MailaAppGoodsOrSpecialDto>> findAppGoodsByNameOrId(Long appId, String nameOrId);

    /**
     * 根据应用id,商品id或商品标题分页查询商品信息
     *
     * @param appId
     * @param offset
     * @param pageSize
     * @return
     */
    DubboResult<List<MailaAppGoodsOrSpecialDto>> findAppGoodsPageByAppId(Long appId, Integer offset, Integer pageSize);


    /**
     * 虚拟库商品批量排期
     *
     * @param appId             应用id
     * @param goodsIds          商品id集
     * @param scheduleTimeStart 商品排期开始时间
     * @param scheduleTimeEnd   商品排期结束时间
     * @return
     */
    DubboResult<Boolean> batchAppGoodsSchedule(Long appId, List<Long> goodsIds, Date scheduleTimeStart, Date scheduleTimeEnd);
}
