package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.maila.biz.center.api.dto.MailaAppDto;

/**
 * 功能描述:
 *
 * @author sunchangji
 * @date 2016/11/21
 */
@AdvancedFeignClient
public interface RemoteMailaAppService {

	/**
	 * 根据appKey获取app信息实体
	 * @param mailaAppKey
	 * @return
	 */
	DubboResult<MailaAppDto> selectByMailaAppKey(String mailaAppKey);

	/**
	 * 根据麦啦appId查找app信息
	 * @param mailaAppId
	 * @return
	 */
	DubboResult<MailaAppDto> selectByMailaAppId(Long mailaAppId);

	/**
	 * 根据兑吧appid 获取对应的运营的麦啦的兑吧 app
	 * @param duibaAppId
	 * @return
     */
	DubboResult<MailaAppDto> findDuibaApp(Long duibaAppId);
}
