package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.MailaAppGoodsOrSpecialDto;
import com.maila.biz.center.api.dto.MailaAppSpecialDto;
import com.maila.biz.center.api.param.MailaAppSpecialQryParam;

import java.util.Date;
import java.util.List;

/**
 * 专场虚拟库管理员后台服务
 * <p>
 * ClassName:RemoteMailaAppSpecialBackendService
 * Date     : 2016年12月20日 16:59:22
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteMailaAppSpecialBackendService {

    /**
     * 分页查询应用专场虚拟库
     *
     * @param mailaAppSpecialQryParam @See MailaAppSpecialQryParam
     * @return
     */
    DubboResult<List<MailaAppSpecialDto>> findAppSpecials(MailaAppSpecialQryParam mailaAppSpecialQryParam);

    /**
     * 分页查询应用专场虚拟库总数
     *
     * @param mailaAppSpecialQryParam @See MailaAppSpecialQryParam
     * @return
     */
    DubboResult<Integer> count4findAppSpecials(MailaAppSpecialQryParam mailaAppSpecialQryParam);

    /**
     * 应用专场虚拟库排期
     *
     * @param appId             应用id
     * @param specialId         专场id
     * @param scheduleStartTime 排期时间起
     * @param scheduleEndTime   排期时间止
     * @return
     */
    DubboResult<Integer> appSpecialSchedule(Long appId, Long specialId, Date scheduleStartTime, Date scheduleEndTime);

    /**
     * 应用专场虚拟库进tab
     *
     * @param appId     应用id
     * @param specialId 专场id
     * @param tabIds    应用tab id集
     * @return
     */
    DubboResult<Integer> appSpecialIntoTab(Long appId, Long specialId, List<Long> tabIds);

    /**
     * 移除应用虚拟专场
     *
     * @param appId      应用id
     * @param specialIds 专场id集
     * @return
     */
    DubboResult<Integer> deleteAppSpecial(Long appId, List<Long> specialIds);

    /**
     * 填充专场虚拟库第一个可用商品的信息(慎用)
     *
     * @param appId     应用id
     * @param specialId 专场id
     * @return
     */
    DubboResult<Integer> fillAppSpecialFirstGoodsInfo(Long appId, Long specialId);

	/**
     * 根据专场名称或专场id查询专场信息
     * @param appId 应用id
     * @param nameOrId 专场名称或专场id
     * @return
     */
    DubboResult<List<MailaAppGoodsOrSpecialDto>> selectAppSpecialByNameOrId(Long appId,String nameOrId);

	/**
     * 查询待生效和生效中专场集合
     * @param appId
     * @return
     */
    DubboResult<List<MailaAppGoodsOrSpecialDto>> selectAppSpecialByAppId(Long appId);

}


