package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

import com.maila.biz.center.api.dto.MailaAppBannerDto;

/**
 * 功能描述:供手机端提供banner数据
 *
 * @author sunchangji
 * @date 2016/11/9
 */
@AdvancedFeignClient
public interface RemoteMailaBannerService {

	/**
	 * 获取app下启用的banner列表
	 *
	 * @param appId    应用id
	 * @param pageSize 条数
	 * @return
	 */
	DubboResult<List<MailaAppBannerDto>> getBannerListByAppId(Long appId, Integer pageSize);

	/**
	 * 根据bannerId查询banner
	 * @param id  bannerId
	 * @return DubboResult<MailaAppBannerDto>
	 */
	DubboResult<MailaAppBannerDto> selectUrlBannerById(Long id);
}
