package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

import com.maila.biz.center.api.dto.MailaCouponInfoDto;

/**
 * 功能描述:优惠券监控信息
 *
 * @author sunchangji
 * @date 2017/2/6
 *
 * 已过时,不要再使用
 */
@AdvancedFeignClient
public interface RemoteMailaCouponInfoBackendService {
	/**
	 * 根据条件组合查询，分页获取正在上线的优惠券信息
	 *
	 * @param goodsId     商品名称
	 * @param couponStock 优惠券库存小于的数
	 * @param offset      分页开始条数
	 * @param pageSize    页距
	 * @return DubboResult<List<MailaCouponInfoDto>>
	 */
	DubboResult<List<MailaCouponInfoDto>> selectByConditionPage(Long goodsId, Long couponStock, Integer offset, Integer pageSize);

	/**
	 * 根据条件组合查询查询总记录数
	 *
	 * @param goodsId     商品名称
	 * @param couponStock 优惠券库存小于的数
	 *
	 * @return DubboResult<Integer>
	 */
	DubboResult<Integer> countByConditionPage(Long goodsId, Long couponStock);

	/**
	 * 查询优惠券商品预警未核对的记录，
	 * 并过滤掉已经不在线的商品对应的记录
	 *
	 * @param offset   分页开始条数
	 * @param pageSize 页距
	 * @return DubboResult<List<MailaCouponInfoDto>>
	 */
	DubboResult<List<MailaCouponInfoDto>> selectNoCheckedCouponInfo(Integer offset, Integer pageSize);

	/**
	 * 查询优惠券商品预警未核对的记录并过滤掉已经不在线的商品对应的记录总数
	 *
	 * @return DubboResult<Integer>总条数
	 */
	DubboResult<Integer> countNoCheckedCouponInfo();

	/**
	 * 查询优惠券商品预警已核对的记录
	 *
	 * @param offset   分页开始条数
	 * @param pageSize 页距
	 * @return DubboResult<List<MailaCouponInfoDto>>
	 */
	DubboResult<List<MailaCouponInfoDto>> selectCheckedCouponInfo(Integer offset, Integer pageSize);

	/**
	 * 查询优惠券商品预警已核对的记录总条数
	 *
	 * @return DubboResult<Integer>总条数
	 */
	DubboResult<Integer> countCheckedCouponInfo();

	/**
	 * 更新核对状态为已核对
	 * @param goodsId 商品id
	 * @return DubboResult<Boolean>
	 */
	DubboResult<Boolean> updteIsChecked(Long goodsId);

}
