package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.MailaAppGoodsDto;
import com.maila.biz.center.api.dto.MailaGoodsDto;

/**
 * ClassName:RemoteMailaGoodsService
 * Date     : 2017年02月24日 10:05:47
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteMailaGoodsService {

    /**
     * 根据商品id获取优惠券商品uland链接
     *
     * @param goodsId 商品id
     * @return 优惠券地址
     */
    DubboResult<String> selectCouponUlandByGoodsId(Long goodsId);

    /**
     * 根据goodsId查询商品信息
     *
     * @param goodsId
     * @return DubboResult<MailaGoodsDto>
     */
    DubboResult<MailaGoodsDto> selectGoodsByGoodsId(Long goodsId);

    /**
     * 获取商品积分 元
     *
     * @param goodsId
     * @param appId
     * @return
     *
     * 已过时,不要再使用
     */
    DubboResult<Long> getCredits(Long goodsId, Long appId);

    /**
     * 获取 app 商品
     *
     * @param goodsId
     * @param appId
     * @return
     * @throws Exception
     */
    DubboResult<MailaAppGoodsDto> findAppGoods(Long goodsId, Long appId);
}
