package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 定时任务手动执行服务（仅供测试）
 * <p>
 * ClassName:RemoteMailaJobExecuteBackendService
 * Date     : 2016年12月28日 15:21:24
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteMailaJobExecuteBackendService {

    /**
     * 执行填充专场第一个可用商品信息的定时任务 (如果没有参数即执行全局所有专场虚拟库)
     *
     * @param appId     应用id
     * @param specialId 专场id
     * @return
     */
    DubboResult<Boolean> executeSpecialFillFirstGoodsInfoJob(Long appId, Long specialId);

    /**
     * 执行商品归档定时任务
     *
     * @return
     */
    DubboResult<Boolean> executeGoodsArchiveJob();

    /**
     * 执行检查自动启用禁用时间定时任务
     *
     * @return
     */
    DubboResult<Boolean> executeCheckAutoStartAndEndTimeJob();
}
