package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.MailaMerchantsDto;

import java.util.List;
import java.util.Map;

/**
 * 麦啦商家服务类
 * <p>
 * ClassName:RemoteMailaMerchantsBackendService
 * Created by zhf on 2016/11/25.
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteMailaMerchantsBackendService {

	/**
	 * 查询所有商家信息
	 *
	 * @param offset   偏移量
	 * @param pageSize 每页数量
	 * @return 商家列表集
	 */
	DubboResult<List<MailaMerchantsDto>> findAllMerchantsPage(String account, String contact, Integer offset, Integer pageSize);

	/**
	 * 查询所有商家数
	 *
	 * @return
	 */
	DubboResult<Long> countForFindAllMerchantsPage(String account, String contact);

	/**
	 * 根据商家id查询商家信息
	 * @param merchantsIdList 商家id集合
	 * @return
	 */
	DubboResult<Map<Long, MailaMerchantsDto>> findMerchantsByIds(List<Long> merchantsIdList);

	/**
	 * 根据商家id查询商家信息
	 * @param id 商家id
	 * @return
	 */
	DubboResult<MailaMerchantsDto> findMerchantById(Long id);
}
