package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

import com.maila.biz.center.api.dto.MailaMerchantsGoodsDto;
import com.maila.biz.center.api.param.MailaMerchantsGoodsQryParam;

/**
 * 功能描述:麦啦商家商品接口类
 *
 * @author sunchangji
 * @date 2016/12/8
 */
@AdvancedFeignClient
public interface RemoteMailaMerchantsGoodsBackendService {
	/**
	 * 根据商品类型、所属类目、商品id、商品标题、审核状态查询商家商品数据（分页）
	 *
	 * @param mailaMerchantsGoodsQryParam 商家商品查询参数
	 * @return
	 */
	DubboResult<List<MailaMerchantsGoodsDto>> findByMoreConditions(MailaMerchantsGoodsQryParam mailaMerchantsGoodsQryParam);

	/**
	 * 根据商品类型、所属类目、商品id、商品标题、审核状态查询商家商品数据（分页）
	 *
	 * @param mailaMerchantsGoodsQryParam 商家商品查询参数
	 * @return
	 */
	DubboResult<Long> countFindByMoreConditions(MailaMerchantsGoodsQryParam mailaMerchantsGoodsQryParam);

	/**
	 * 管理员后台商家商品审核
	 * @param mailaMerchantsGoodsDto 商家商品审核数据
	 * @return
	 */
	DubboResult<Boolean> audit(MailaMerchantsGoodsDto mailaMerchantsGoodsDto);

	/**
	 * 根据goodsId查询商家商品信息
	 * @param goodsId
	 * @return
	 */
	DubboResult<MailaMerchantsGoodsDto> findByGoodsId(Long goodsId);

	/**
	 * 待审核商品中是否已存在有效期有冲突的商品
	 * @param itemId
	 * @param autoStartTime
	 * @param autoEndTime
	 * @return
	 */
	DubboResult<Boolean> isExistMerchantsGoods(Long itemId, Date autoStartTime, Date autoEndTime);
}
