package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

import com.maila.biz.center.api.dto.MailaShopDto;
import com.maila.biz.center.api.dto.MailaShopQueryDto;

/**
 * 后台商家店铺服务类
 *
 * @ClassName RemoteMailaShopBackendService
 * @Author zhanghuifeng
 * @Date 10:24 2016/11/28
 */
@AdvancedFeignClient
public interface RemoteMailaShopBackendService {


	/**
	 * 管理员后台通过条件查询商家店铺审核信息（分页）
	 *
	 * @param mailaShopParamDto 参数对象
	 *
	 * @return DubboResult<List<MailaShopDto>>
	 */
	DubboResult<List<MailaShopDto>> findShopsAuditInfoByCondition(MailaShopQueryDto mailaShopParamDto);

	/**
	 *管理员后台通过条件查询商家店铺审核信息数量（分页）
	 *
	 * @param shopType   店铺类型
	 * @param mainType	 主营类目
	 * @param shopName   店铺名称
	 * @param startTime  提交审核开始时间
	 * @param endTime    提交审核结束时间
	 * @param auditStatus 审核状态
	 * @return
	 */
	DubboResult<Long> countForFindShopsAuditInfoByCondition(Integer shopType, Integer mainType, String shopName, Date startTime, Date endTime, Integer auditStatus);

	/**
	 * 管理员后台商家店铺管理查询（分页）
	 *
	 * @param shopType 店铺类型
	 * @param mainType 主营类目
	 * @param shopKeeper 掌柜
	 * @param auditor   审核人
	 * @param offset     偏移量
	 * @param pageSize   每页数量
	 * @return
	 */
	DubboResult<List<MailaShopDto>> findShopsManageInfo(Integer shopType, Integer mainType, String shopKeeper, String auditor, Integer offset, Integer pageSize);

	/**
	 * 管理员后台商家店铺管理查询数量（分页）
	 *
	 * @param shopType 店铺类型
	 * @param mainType 主营类目
	 * @param shopKeeper 掌柜
	 * @param auditor   审核人
	 * @return
	 */
	DubboResult<Long> countFindShopsManageInfo(Integer shopType, Integer mainType, String shopKeeper, String auditor);

	/**
	 * 管理员后台商家店铺审核
	 *
	 * @param id       店铺Id
	 * @param auditStatus  审核状态
	 * @param refuseReason 审核不通过原因
	 * @param auditor 审核人
	 * @return
	 */
	DubboResult<Integer> auditingShop(Long id, Integer auditStatus, String refuseReason, String auditor);

	/**
	 * 管理员后台编辑店铺信息
	 *
	 * @param mailaShopsDto 店铺信息
	 * @return
	 */
	DubboResult<Integer> updateShopInfo(MailaShopDto mailaShopsDto);

	/**
	 * 管理员后台冻结店铺
	 *
	 * @param shopId          店铺ID
	 * @param frozenStartTime 冻结开始时间
	 * @param frozenEndTime	  冻结结束时间
	 * @param auditor         审核人
	 * @return
	 */
	DubboResult<Integer> saveShopFrozenInfo(Long shopId, Date frozenStartTime, Date frozenEndTime, String auditor);

	/**
	 * 根据店铺id查询店铺信息
	 * @param id 店铺id
	 * @return
	 */
	DubboResult<MailaShopDto> findShopsById(Long id);
}
