package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.maila.biz.center.api.dto.MailaGoodsDto;
import com.maila.biz.center.api.dto.MailaSpecialDto;
import com.maila.biz.center.api.dto.MailaSpecialIdAndNameDto;
import com.maila88.common.dto.Maila88SelectDto;

import java.util.List;

/**
 * 麦啦专场后台管理服务类
 * <p>
 * ClassName:RemoteMailaSpecialBackendService
 * Date     : 2016年11月07日 16:22:33
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteMailaSpecialBackendService {

    /**
     * 根据名称模糊查询专场 （分页查询）
     *
     * @param name4admin 管理员后台专场名称
     * @param title      专场标题
     * @param offset     偏移量
     * @param pageSize   每页数量
     * @return 专场列表集
     */
    DubboResult<List<MailaSpecialDto>> findByNameOrTitle(String name4admin, String title, Integer offset, Integer pageSize);

    /**
     * 根据名称模糊查询专场总数量 （分页查询）
     *
     * @param name4admin 管理员后台专场名称
     * @param title      专场标题
     * @return
     */
    DubboResult<Long> countForFindByNameOrTitle(String name4admin, String title);

    /**
     * 添加麦啦专场
     *
     * @param mailaSpecialDto 参数
     * @return Boolean
     */
    DubboResult<Boolean> addMailaSpecial(MailaSpecialDto mailaSpecialDto);

    /**
     * 更新麦啦专场
     *
     * @param mailaSpecialDto 参数
     * @return Boolean
     */
    DubboResult<Boolean> updateMailaSpecial(MailaSpecialDto mailaSpecialDto);

    /**
     * 删除麦啦专场
     *
     * @param specialId 专场id
     * @return
     */
    DubboResult<Integer> deleteMailaSpecial(Long specialId);

    /**
     * 根据专场id查询商品
     *
     * @param specialId 专场id
     * @return
     */
    DubboResult<List<MailaGoodsDto>> findSpecialGoods(Long specialId);

    /**
     * 删除专场下的商品
     *
     * @param specialId 专场id
     * @param goodsIds  要删除的商品id集
     * @return
     */
    DubboResult<Integer> delSpecialGoods(Long specialId, String goodsIds);

    /**
     * 根据专场id获取专场
     *
     * @param specialId 专场id
     * @return
     */
    DubboResult<MailaSpecialDto> findBySpecialId(Long specialId);

    /**
     * 根据名称或id查询所有专场
     *
     * @param value 名称或id
     * @return
     */
    DubboResult<List<Maila88SelectDto>> findSpecialByNameOrId(String value);

    /**
     * 更新专场下的商品(商品重排序)
     *
     * @param specialId 专场id
     * @param goodsIds  需要保存的有序的商品id集,例:1,2,3,4
     * @return
     */
    DubboResult<Integer> updateSpecialGoods(Long specialId, String goodsIds);

    /**
     * 多个商品添加单个专场
     *
     * @param goodsIds  商品id集
     * @param specialId 专场id
     * @return
     */
    DubboResult<Integer> addSpecialGoods(Long specialId, String goodsIds);

    /**
     * 专场进应用
     *
     * @param specialId 专场id
     * @param appIds    应用id
     * @return
     */
    DubboResult<Integer> addAppSpecial(Long specialId, List<Long> appIds);


    /**
     * 主库专场失效
     *
     * @param specialId 专场id
     * @return
     */
    DubboResult<Integer> disabledSpecial(Long specialId);

    /**
     * 多个商品添加至专场
     *
     * @param specialId 专场id
     * @param goodsIdsOrItemIds  有序的商品id或淘宝商品ID集合，例:1,2,3,4
     * @param goodsIdOrItemIdType See GoodsIdOrItemIdTypeEnum
     * @return Boolean
     */
    DubboResult<Boolean> batchAddSpecialGoods(Long specialId, String goodsIdsOrItemIds, int goodsIdOrItemIdType);

    /**
     * 批量对专场下商品进行排序
     * @param specialId 专场id
     * @param goodsIdsOrItemIds  有序的商品id或淘宝商品ID集合，例:1,2,3,4
     * @param goodsIdOrItemIdType See GoodsIdOrItemIdTypeEnum
     * @return Boolean
     */
    DubboResult<Boolean> batchSortGoods(Long specialId,String goodsIdsOrItemIds, int goodsIdOrItemIdType);

    /**
     * 移除专场库中已失效商品
     * @param specialId  专场ID
     * @return Boolean
     */
    DubboResult<Boolean> deleteInvalidSpecialGoods(Long specialId);


    /**
     * 获取专场id和名称列表数据
     *
     * @return
     */
    DubboResult<List<MailaSpecialIdAndNameDto>> findGoodsIdAndName();
}
