package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.MailaCategoryTabGoodsDto;
import com.maila.biz.center.api.dto.MailaTabDto;
import com.maila.biz.center.api.dto.TabGoodsSpecialDto;
import com.maila.biz.center.api.dto.TodayRobTabContentDto;

import java.util.List;

/**
 * 功能描述:供手机端提供Tab数据
 *
 * @author sunchangji
 * @date 2016/11/9
 */
@AdvancedFeignClient
public interface RemoteMailaTabService {

	/**
	 * 根据应用id获取启用的tab列表数据
	 *
	 * @param appId 应用id
	 * @return
	 */
	DubboResult<List<MailaTabDto>> selectTabListByAppId(Long appId);

	/**
	 * 根据应用id和tabId分页获取tab下已上架商品或专场数据
	 *
	 * @param appId 应用id
	 * @param tabId
	 * @param pageStart 第几页
	 * @param pageSize  一页多少条
	 * @return
	 */
	DubboResult<List<TabGoodsSpecialDto>> selectTabGoodsSpecialByAppIdAndTabId(Long appId, Long tabId,Integer pageStart,Integer pageSize);

	/**
	 * 获取类目tab下的商品列表
	 *
	 * @param appId     应用id
	 * @param tabId     tab id
	 * @param id        商品记录id
	 * @param pageSize  每页数量
	 * @return
	 */
	DubboResult<List<MailaCategoryTabGoodsDto>> findCategoryGoodsList(Long appId, Long tabId, Long id, Integer pageSize);

	/**
	 * 获取tab下商品或专场总个数
	 * @param appId 应用id
	 * @param tabId tabId
	 * @return int 总条数
	 */
	DubboResult<Integer> selectTabGoodsSpecialTotalCount(Long appId,Long tabId);

	/**
	 * 获取今日必砍的 tab 内容
	 * @param mailaAppId
	 * @param mailaDeveloperId
	 * @param duibaAppId
	 * @param tabId
	 * @param pageStart
	 * @param pageSize
	 * @return
	 */
	DubboResult<List<TodayRobTabContentDto>> findTodayRobTabContent(Long mailaAppId, Long mailaDeveloperId, Long duibaAppId, Long tabId, Integer pageStart, Integer pageSize);

	/**
	 * 获取今日必抢类目tab下的商品内容
	 *
	 * @param mailaAppId
	 * @param mailaDeveloperId
	 * @param duibaAppId
	 * @param recordId           当前页第后一条商品的记录id
	 * @param tabId
	 * @param pageSize
	 * @return
	 */
	DubboResult<List<TodayRobTabContentDto>> findTodayRobCategoryTabContent(Long mailaAppId, Long mailaDeveloperId, Long duibaAppId, Long recordId, Long tabId, Integer pageSize);
}
