package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 功能描述:修复优惠价商品的itemId值
 *
 * @author sunchangji
 * @date 2017/1/20
 */
@AdvancedFeignClient
public interface RemoteRepairItemIdBackendService {

	/**
	 * 修复商品主库中优惠券类型商品的itemId值
	 * @return  DubboResult<Boolean>
	 */
	DubboResult<Boolean> repairMailaGoodsItemId();

	/**
	 * 修复类目tab的tab_type值为2
	 * category_id部位空，设置tab_type=2
	 * @return
	 */
	DubboResult<Boolean> repairMailaCategoryTabType();
}
