package com.maila.biz.center.api.remoteservice.merchants.platform;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;

import com.maila.biz.center.api.dto.merchants.Maila88MerchantsGoodsDto;
import com.maila88.common.dto.Maila88PageDto;

/**
 * 商家后台使用的商品相关操作接口类
 * Author: zhanghuifeng
 * Date:   10:35 2017/4/25
 */
@AdvancedFeignClient
public interface RemoteMaila88MerchantsGoodsService {
	/**
	 * 分页条件查询商家商品表信息
	 *
	 * @param shopId      店铺id
	 * @param goodsType   商品类型
	 * @param goodsStatus 审核状态
	 * @param title       商品标题
	 * @param pageStart   页数
	 * @param pageSize    分页页距
	 * @return Maila88PageDto<Maila88MerchantsGoodsDto>
	 */
	DubboResult<Maila88PageDto<Maila88MerchantsGoodsDto>> findMerchantsGoodsByPage(Long shopId, Integer goodsType, Integer goodsStatus, String title, Integer pageStart, Integer pageSize);

	/**
	 * 根据id查询商家商品库商品信息
	 *
	 * @param goodsId 商家商品id(id发号器生成的id)
	 * @return Maila88MerchantsGoodsDto
	 */
	DubboResult<Maila88MerchantsGoodsDto> findMerchantsGoodsByGoodsId(Long goodsId);

	/**
	 * 根据主键删除商家商品库商品记录,逻辑删除
	 *
	 * @param goodsId 商品id
	 * @return Boolean
	 */
	DubboResult<Boolean> deleteMerchantsGoodsByGoodsId(Long goodsId);

	/**
	 * 新增商家商品记录
	 *
	 * @param mailaMerchantsGoodsDto 参数
	 * @return goodsId
	 */
	DubboResult<Long> insertMerchantsGoods(Maila88MerchantsGoodsDto mailaMerchantsGoodsDto);

	/**
	 * 更新商家商品记录
	 *
	 * @param mailaMerchantsGoodsDto 参数
	 * @return Boolean
	 */
	DubboResult<Boolean> updateMerchantsGoods(Maila88MerchantsGoodsDto mailaMerchantsGoodsDto);

	/**
	 * 查询商家商品库是否存在审核中的商品
	 *
	 * @param itemId 淘宝商品id
	 * @return Boolean
	 */
	DubboResult<Boolean> isExistAuditingMerchantsGoods(Long itemId);

	/**
	 * 查询麦啦正式库中是否存在交叉排期的商品
	 *
	 * @param itemId                 淘宝商品id
	 * @param finalScheduleStartTime 最终可排期开始时间(和submitDate的交集开始时间)
	 * @param finalScheduleEndTime   最终可排期结束时间(和submitDate的交集结束时间)
	 * @return Boolean
	 */
	DubboResult<Boolean> isExistInMailaGoods(Long itemId, Date finalScheduleStartTime, Date finalScheduleEndTime);
}
