package com.maila.biz.center.api.remoteservice.merchants.platform;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

import com.maila.biz.center.api.dto.BusinessMsgDto;
import com.maila.biz.center.api.dto.merchants.Maila88ShopDto;
import com.maila.biz.center.api.dto.merchants.Maila88ShopPlatformDto;

/**
 * 商家端店铺服务接口
 * Author: zhanghuifeng
 * Date:   15:32 2017/4/25
 */
@AdvancedFeignClient
public interface RemoteMaila88ShopService {
	/**
	 * 商家添加店铺
	 *
	 * @param mailaShopDto 参数
	 * @return BusinessMsgDto
	 */
	DubboResult<BusinessMsgDto> addShop(Maila88ShopDto mailaShopDto);

	/**
	 * 更新店铺信息
	 *
	 * @param mailaShopDto 参数
	 * @return BusinessMsgDto
	 */
	DubboResult<BusinessMsgDto> updateShop(Maila88ShopDto mailaShopDto);

	/**
	 * 获取商家所有店铺
	 *
	 * @param merchantsId 商家id
	 * @return List<Maila88ShopDto>
	 */
	DubboResult<List<Maila88ShopDto>> findShops(Long merchantsId);

	/**
	 * 获取店铺信息
	 *
	 * @param merchantsId 商家id
	 * @param shopId      店铺id
	 * @param status      店铺状态 @See MailaShopAuditStatus
	 * @return Maila88ShopDto
	 */
	DubboResult<Maila88ShopDto> findShop(Long merchantsId, Long shopId, Integer status);

	/**
	 * 根据店铺id和商家id查询店铺
	 *
	 * @param id          店铺id
	 * @param merchantsId 商家id
	 * @return Maila88ShopPlatformDto
	 */
	DubboResult<Maila88ShopPlatformDto> findShopByIdAndMerchantsId(Long id, Long merchantsId);
}
