package com.maila88.common.dto;

import java.io.Serializable;
import java.util.List;

/**
 *  分页返回结果集
 *
 * Created by huangsenfa on 2017/4/4.
 */
public class Maila88PageDto<T extends Serializable> implements Serializable {

    private static final long serialVersionUID = 6683029315645230752L;

    /**
     * 当前页返回的数据列表
     */
    private List<T>  pageData;

    /**
     * 分页查询的数据总数
     */
    private Integer  totalCount;

    public Maila88PageDto() {
        super();
    }

    public Maila88PageDto(List<T>  pageData, Integer totalCount) {
        this.pageData = pageData;
        this.totalCount =  totalCount;
    }

    public List<T> getPageData() {
        return pageData;
    }

    public void setPageData(List<T> pageData) {
        this.pageData = pageData;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }
}
