package com.maila88.common.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by peanuthuang on 2017/6/1.
 */
public enum  Maila88EnvironmentEnum {

     ONLINE(1,"online","线上环境"),
     PREPUB(2,"prepub","预发环境"),
     DAILY(3, "daily","测试环境"),
     DEV(4,"dev","开发环境");

    /**
     * 状态值
     */
    private int status;

    /**
     * 名称
     */
    private String name;

    /**
     * 描述
     */
    private String desc;

    Maila88EnvironmentEnum(int status, String name, String desc) {
        this.status = status;
        this.name = name;
        this.desc = desc;
    }

    /**
     * 根据名称获取环境类型
     *
     * @param name
     * @return
     */
   public static Maila88EnvironmentEnum getByName(String name){

        if(StringUtils.isBlank(name)){
            return null;
        }

        Maila88EnvironmentEnum [] environmentEnums = Maila88EnvironmentEnum.values();
        for(Maila88EnvironmentEnum environmentEnum : environmentEnums){
            if(name.equals(environmentEnum.getName())){
                return environmentEnum;
            }
        }
        return null;
    }

    public int getStatus() {
        return status;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }
}
