package com.maila88.modules.activity.dto;

import com.maila88.modules.goods.enums.Maila88GoodsStatusEnum;
import com.maila88.modules.goods.enums.Maila88GoodsTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动下商品dto
 *
 * Created by peanut.huang on 2017/9/7.
 */
public class Maila88ActivityGoodsDto implements Serializable {

    private static final long serialVersionUID = -1366504808719632802L;

    /**
     * 自增 id
     */
    private Long id;

    /**
     * 麦啦商品id,id发号器生成
     **/
    private Long goodsId;

    /**
     * 淘宝商品id,用于查询
     **/
    private Long itemId;

    /**
     * 优惠券详细信息链接地址
     **/
    private String couponUrl;

    /**
     * 商品名称,用于管理员后台展示
     **/
    private String name4admin;

    /**
     * 商品标题
     **/
    private String title;

    /**
     * 商品副标题
     **/
    private String subTitle;

    /**
     * 商品类型 {@link Maila88GoodsTypeEnum#value}
     */
    private Integer goodsType;

    /**
     * 商品类型:淘宝itemId,url {@link Maila88GoodsTypeEnum#name}
     */
    private String goodsTypeName;

    /**
     * 商品类型内容:(优惠券商品:url,优惠价商品:淘宝itemID)
     **/
    private String goodsContent;

    /**
     * 商品原价
     **/
    private Integer originalPrice;

    /**
     * 商品优惠价
     **/
    private Integer preferPrice;

    /**
     * 商品现价
     **/
    private Integer finalPrice;

    /**
     * 商品主图
     **/
    private String  imgUrl;

    /**
     * 商品状态值:待上架，已上架，已下架等 {@link Maila88GoodsStatusEnum#value}
     */
    private Integer goodsStatus;

    /**
     * 商品状态值:待上架，已上架，已下架等 {@link Maila88GoodsStatusEnum#name}
     */
    private String goodsStatusName;

    /**
     * 平台标识(-1:其他 0:淘宝,1:天猫)
     **/
    private Integer platformType;

    /**
     * 类目
     */
    private Integer category;

    /**
     * 类目名称
     **/
    private String categoryName;

    /**
     * 自动启动时间
     */
    private Date autoStartTime;

    /**
     * 自动结束时间
     */
    private Date autoEndTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getCouponUrl() {
        return couponUrl;
    }

    public void setCouponUrl(String couponUrl) {
        this.couponUrl = couponUrl;
    }

    public String getName4admin() {
        return name4admin;
    }

    public void setName4admin(String name4admin) {
        this.name4admin = name4admin;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public Integer getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(Integer goodsType) {
        this.goodsType = goodsType;
    }

    public String getGoodsTypeName() {
        return goodsTypeName;
    }

    public void setGoodsTypeName(String goodsTypeName) {
        this.goodsTypeName = goodsTypeName;
    }

    public String getGoodsContent() {
        return goodsContent;
    }

    public void setGoodsContent(String goodsContent) {
        this.goodsContent = goodsContent;
    }

    public Integer getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(Integer originalPrice) {
        this.originalPrice = originalPrice;
    }

    public Integer getPreferPrice() {
        return preferPrice;
    }

    public void setPreferPrice(Integer preferPrice) {
        this.preferPrice = preferPrice;
    }

    public Integer getFinalPrice() {
        return finalPrice;
    }

    public void setFinalPrice(Integer finalPrice) {
        this.finalPrice = finalPrice;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Integer getGoodsStatus() {
        return goodsStatus;
    }

    public void setGoodsStatus(Integer goodsStatus) {
        this.goodsStatus = goodsStatus;
    }

    public String getGoodsStatusName() {
        return goodsStatusName;
    }

    public void setGoodsStatusName(String goodsStatusName) {
        this.goodsStatusName = goodsStatusName;
    }

    public Integer getPlatformType() {
        return platformType;
    }

    public void setPlatformType(Integer platformType) {
        this.platformType = platformType;
    }

    public Integer getCategory() {
        return category;
    }

    public void setCategory(Integer category) {
        this.category = category;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Date getAutoStartTime() {
        return autoStartTime;
    }

    public void setAutoStartTime(Date autoStartTime) {
        this.autoStartTime = autoStartTime;
    }

    public Date getAutoEndTime() {
        return autoEndTime;
    }

    public void setAutoEndTime(Date autoEndTime) {
        this.autoEndTime = autoEndTime;
    }
}
