package com.maila88.modules.activity.enums;

import java.util.Arrays;

/**
 * Created by peanut.huang on 2017/9/7.
 */
public enum Maila88ActivityStatusEnum {

    READY(0,"待发布"),

    PUBLISHED(1,"已发布");


    private int id;

    private String desc;


    Maila88ActivityStatusEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    public static Maila88ActivityStatusEnum findById(Integer id){
        if(id == null){
            return null;
        }
        return Arrays.stream(Maila88ActivityStatusEnum.values()).filter(e -> id.equals(e.getId())).findFirst().orElse(null);
    }

    public int getId() {
        return id;
    }

    public String getDesc() {
        return desc;
    }
}
