package com.maila88.modules.activity.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.activity.dto.Maila88ActivityDto;

/**
 * 活动后台服务
 *
 * Created by peanut.huang on 2017/9/7.
 */
@AdvancedFeignClient
public interface RemoteMaila88ActivityBackendService {

    /**
     * 活动分页列表
     *
     * @param name4admin  活动名称
     * @param pageNum
     * @param pageSize
     * @return
     */
    Maila88PageDto<Maila88ActivityDto> listPages(String name4admin, Integer pageNum, Integer pageSize);

    /**
     * 保存活动
     *
     * @param activityDto
     * @return              活动id
     */
    Long saveActivity(Maila88ActivityDto activityDto);

    /**
     * 删除活动
     *
     * @param activityId  活动id
     * @return
     */
    Boolean deleteActivity(Long activityId);

    /**
     * 根据活动id查询活动
     *
     * @param activityId
     * @return
     */
    Maila88ActivityDto findById(Long activityId);
}
