package com.maila88.modules.activity.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.maila88.modules.activity.dto.Maila88ActivityModuleCountDownDto;
import com.maila88.modules.activity.dto.Maila88ActivityModuleDto;
import com.maila88.modules.activity.dto.Maila88ActivityModuleGoodsDto;
import com.maila88.modules.activity.dto.Maila88ActivityModuleHotDto;

import java.util.List;

/**
 * 活动组件后台服务
 *
 * Created by peanut.huang on 2017/9/12.
 */
@AdvancedFeignClient
public interface RemoteMaila88ActivityModuleBackendService {

    /**
     * 列出活动下的组件列表
     *
     * @param activityId   活动id
     * @return
     */
    List<Maila88ActivityModuleDto> listActivityModule(Long activityId);

    /**
     * 活动组件拖拽排序保存
     *
     * @param activityId              活动id
     * @param activityModuleDtoList   组件列表
     * @return
     */
    Boolean saveActivityModule(Long activityId, List<Maila88ActivityModuleDto> activityModuleDtoList);

    /**
     * 删除活动组件
     *
     * @param activityId              活动id
     * @param activityModuleId        活动组件id
     * @return
     */
    Boolean deleteActivityModule(Long activityId, Long activityModuleId);

    /**
     * 查询活动商品区组件的详情数据
     *
     * @param activityId          活动id
     * @param activityModuleId    活动组件id
     * @return
     */
    Maila88ActivityModuleGoodsDto findModuleGoods(Long activityId, Long activityModuleId);

    /**
     * 保存活动商品区组件的详情数据
     *
     *  <p>根据activityId,activityModuleId的唯一性判断是插入还是更新</p>
     *
     * @param moduleGoodsDto
     * @return
     */
    Boolean saveModuleGoods(Maila88ActivityModuleGoodsDto moduleGoodsDto);


    /**
     * 查询活动热区组件的详情数据
     *
     * @param activityId          活动id
     * @param activityModuleId    活动组件id
     * @return
     */
    Maila88ActivityModuleHotDto findModuleHot(Long activityId, Long activityModuleId);

    /**
     * 保存活动热区组件的详情数据
     *
     *  <p>根据activityId,activityModuleId的唯一性判断是插入还是更新</p>
     *
     * @param moduleHotDto
     * @return
     */
    Boolean saveModuleHot(Maila88ActivityModuleHotDto moduleHotDto);

    /**
     * 查询活动倒计时组件的详情数据
     *
     * @param activityId          活动id
     * @param activityModuleId    活动组件id
     * @return
     */
    Maila88ActivityModuleCountDownDto findModuleCountDown(Long activityId, Long activityModuleId);

    /**
     * 保存活动倒计时组件的详情数据
     *
     *  <p>根据activityId,activityModuleId的唯一性判断是插入还是更新</p>
     *
     * @param activityModuleCountDownDto
     * @return
     */
    Boolean saveModuleCountDown(Maila88ActivityModuleCountDownDto activityModuleCountDownDto);
}
