package com.maila88.modules.activity.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.maila88.modules.activity.dto.Maila88ActivityDto;
import com.maila88.modules.activity.dto.Maila88ActivityGoods4MobileDto;

import java.util.List;

/**
 * 活动前台服务
 *
 * Created by peanut.huang on 2017/9/7.
 */
@AdvancedFeignClient
public interface RemoteMaila88ActivityService {

    /**
     * 根据活动id查询活动
     *
     * @param activityId
     * @return
     */
    Maila88ActivityDto findById(Long activityId);

    /**
     * 查询活动组件下的商品
     *
     * @param appId
     * @param activityId
     * @param activityModuleId
     * @return
     */
    List<Maila88ActivityGoods4MobileDto> findGoods(Long appId, Long activityId, Long activityModuleId);
}
