package com.maila88.modules.admin.enums;

import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;

/**
 * 麦啦商品状态
 */
public enum Maila88OperateLogEnum {

    SKIN_ADD(1001, "皮肤添加"),
    SKIN_EDIT(1002, "皮肤编辑"),
    APP_SKIN_EDIT(1011, "应用皮肤保存");

    private int    value;
    private String name;

    Maila88OperateLogEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static String getByValue(final int value) {
        Collection<Maila88OperateLogEnum> result = Collections2.filter(Arrays.asList(Maila88OperateLogEnum.values()), gs -> gs.getValue() == value);
        return result.isEmpty() ? "" : result.iterator().next().getName();
    }
}
