package com.maila88.modules.appuser.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.maila88.common.dto.Maila88BusinessMsgDto;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.appuser.dto.Maila88JqgUserEnchashmentDto;
import com.maila88.modules.appuser.dto.Maila88JqgUserSimpleDto;
import com.maila88.modules.appuser.param.Maila88EnchashmentParmam;

/**
 * 手动提现操作
 * <p>
 * Created by sunchangji on 2017/10/19.
 */
@AdvancedFeignClient
public interface RemoteMaila88ManualEnchashBackendService {

    /**
     * 查询用户信息
     *
     * @param account  淘宝用户昵称
     * @param offset   分页开始位置
     * @param pageSize 每页条数
     * @return
     */
    Maila88PageDto<Maila88JqgUserSimpleDto> findPageUser(String account, Integer offset, Integer pageSize);

    /**
     * 根据聚钱购用户id查询用户累计收益和可提现金额
     *
     * @param jqgUserId 聚钱购用户id
     * @return
     */
    Maila88JqgUserEnchashmentDto findCashInfoByJqgUserId(Long jqgUserId);

    /**
     * 增加提现记录
     *
     * @param param 参数
     * @return
     */
    Maila88BusinessMsgDto<Boolean> manualInsertEnchashment(Maila88EnchashmentParmam param);

    /**
     *
     * @param jqgUserId
     * @return
     */
    Maila88JqgUserEnchashmentDto findJqgUserById(Long jqgUserId);
}
