package com.maila88.modules.banner.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.banner.dto.Maila88AppBannerDto;

import java.util.List;

/**
 * 功能描述:供手机端提供banner数据
 *
 * @author sunchangji
 * @date 2016/11/9
 */
@AdvancedFeignClient
public interface RemoteMaila88BannerService {

	/**
	 * 获取app下启用的banner列表
	 *
	 * @param appId    应用id
	 * @param pageSize 条数
	 * @return
	 */
	DubboResult<List<Maila88AppBannerDto>> getBannerListByAppId(Long appId, Integer pageSize);

	/**
	 * 根据bannerId查banner关联外链url
	 * @param id  bannerId
	 * @return DubboResult<String>
	 */
	DubboResult<String> selectUrlBannerById(Long id);
}
