package com.maila88.modules.category.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.maila88.modules.category.dto.Maila88TaoBaoCategoryDto;

/**
 * 麦啦淘宝类目接口
 * Author: zhanghuifeng
 * Date:   17:54 2017/10/31
 */
@AdvancedFeignClient
public interface RemoteMaila88TaoBaoCategoryBackendService {

	/**
	 * 从商品主库中将所有淘宝类目信息存入淘宝类目表
	 * @return boolean
	 */
	Boolean repairTaoBaoCategory();

	/**
	 * 按淘宝一级类目排序获取淘宝类目信息
	 * @param catName 淘宝一级类目
	 * @return 集合
	 */
	List<Maila88TaoBaoCategoryDto> findByCatNameSort(String catName);
}
