package com.maila88.modules.floor.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.floor.dto.Maila88FloorDto;
import com.maila88.modules.floor.dto.Maila88FloorInfoSaveDto;
import com.maila88.modules.floor.dto.Maila88FloorTypeDto;

import java.util.List;

/**
 * Created by peanuthuang on 2017/5/16.
 */
@AdvancedFeignClient
public interface RemoteMaila88FloorBackendService {

    /**
     * 获取 全部楼层信息
     * @param floorType
     * @param pageOffSet
     * @param pageSize
     * @return
     */
    DubboResult<List<Maila88FloorDto>> getAllFloorInfo(Integer floorType, String floorName, Integer pageOffSet, Integer pageSize);

    /**
     * 获取 全部楼层信息数量
     * @param floorType
     * @return
     */
    DubboResult<Long> getCount4AllFloorInfo(Integer floorType, String floorName);

    /**
     * 根据有序的楼层id集查询楼层信息
     *
     * @param floorIds   楼层id集
     * @return 返回以楼层id为顺序的楼层信息集
     */
    DubboResult<List<Maila88FloorDto>> findByIds(List<Long> floorIds);

    /**
     * 保存楼层信息
     * @param maila88FloorInfoSaveDto
     * @return
     */
    DubboResult<Boolean> saveFloorInfo(Maila88FloorInfoSaveDto maila88FloorInfoSaveDto);

    /**
     * 获取全部楼层类型
     * @return
     */
    DubboResult<List<Maila88FloorTypeDto>> getAllFloorType();

    /**
     * 查找某一类所有楼层信息
     * @param floorType
     * @return
     */
    DubboResult<List<Maila88FloorDto>> getOneTypeFloorInfo(Integer floorType);

    /**
     * 通过floorId 查询app使用者
     * @param floorId
     * @return
     */
    DubboResult<String> findUseNames(Long floorId);

}