package com.maila88.modules.ipwhite.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by sunchangji on 2017/10/25.
 */
@AdvancedFeignClient
public interface RemoteMaila88IpWhiteService {

    /**
     * 查询开发者ip是否在白名单列表中
     *
     * @param devId
     * @return Maila88IpWhiteEntity
     */
    List<String> findIpsByDevId(Long devId);

    /**
     * 新增开发者ip白名单
     *
     * @param devId
     * @param ip
     * @return
     */
    Boolean insert(Long devId, String ip);

    /**
     * 通过开发者账号查询开发者对应id
     *
     * @param account
     * @return
     */
    Long findDevIdByAccount(String account);
}
