package com.maila88.modules.merchants.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 商家商品
 * Author: zhanghuifeng
 * Date:   14:56 2017/4/26
 */
public class Maila88MerchantsGoodsDto implements Serializable {

	private static final long serialVersionUID = 8537758763258568974L;
	/**
	 * 主键
	 **/
	private Long id;

	/**
	 * 麦啦商品id,id发号器生成
	 **/
	private Long goodsId;

	/**
	 * 淘宝商品id
	 **/
	private Long itemId;

	/**
	 * 商家id(麦啦库的商家id)
	 **/
	private Long merchantsId;

	/**
	 * 店铺id(麦啦库的店铺id)
	 **/
	private Long shopId;

	/**
	 * 店铺名称
	 */
	private String shopName;

	/**
	 * 店铺旺旺号
	 */
	private String shopWangwang;

	/**
	 * 商品标题
	 **/
	private String title;

	/**
	 * 商品url
	 **/
	private String itemUrl;

	/**
	 * 商品主图
	 **/
	private String imgUrl;

	/**
	 * 商品原价格
	 **/
	private Integer originalPrice;

	/**
	 * 麦啦专享价
	 **/
	private Integer preferPrice;

	/**
	 * 商品类型(1:优惠券[URL],2:优惠价[淘宝商品])
	 **/
	private Integer goodsType;

	/**
	 * 商品类目(1女装,2男装,3鞋包,4内衣,5饰品,6运动,
	 * 7美妆,8童装,9食品,10母婴,11百货,12汽车,13家电,
	 * 14数码,15家装,16家纺,17其他)
	 **/
	private Integer category;

	/**
	 * 商品库存
	 **/
	private Long stock;

	/**
	 * 佣金比例
	 **/
	private Integer commissionRate;

	/**
	 * 活动计划类型(1.通用,2:定向,3:鹊桥，该字段作为优惠券商品拼接url类型依据)
	 **/
	private Integer planType;

	/**
	 * 计划名称
	 **/
	private String planName;

	/**
	 * 计划链接
	 **/
	private String planUrl;

	/**
	 * 审核状态(1:待提交,2:待审核,3:审核不通过,4:审核通过,5:活动中,6:已失效,7:已结束)
	 **/
	private Integer goodsStatus;

	/**
	 * 审核不通过原因或下架原因
	 **/
	private String reasonMsg;

	/**
	 * 优惠券id
	 **/
	private String couponId;

	/**
	 * 优惠券详细信息地址
	 */
	private String couponUrl;

	/**平台标识(-1:其他 0:淘宝,1:天猫)**/
	private Integer platformType;

	/**30天销量**/
	private Long volume;

	/**
	 * 提交审核时间
	 **/
	private Date submitTime;

	/**
	 * 优惠价或优惠券有效开始日期
	 **/
	private Date effectiveStartTime;

	/**
	 * 优惠价或优惠券有效结束日期
	 **/
	private Date effectiveEndTime;

	/**
	 * 计划开始时间
	 **/
	private Date planStartTime;

	/**
	 * 计划开始结束
	 **/
	private Date planEndTime;

	/**
	 * 可排期开始时间(effective_time和plan_time交集的开始时间)
	 **/
	private Date enableScheduleStartTime;

	/**
	 * 可排期开始时间(effective_time和plan_time交集的结束时间)
	 **/
	private Date enableScheduleEndTime;

	/**
	 * 最终可排期开始时间(enable_schedule_time与submit_time交集开始时间)
	 **/
	private Date finalScheduleStartTime;

	/**
	 * 最终可排期开始时间(enable_schedule_time与submit_time交集结束时间)
	 **/
	private Date finalScheduleEndTime;

	/**
	 * 麦啦排期开始时间(对应麦啦商品库的autoStartTime)
	 **/
	private Date scheduleStartTime;

	/**
	 * 麦啦排期开始时间(对应麦啦商品库的autoEndTime)
	 **/
	private Date scheduleEndTime;

	/**
	 * 商品现价
	 */
	private Integer finalPrice;

	/**
	 * 审核人ID
	 */
	private String auditor;

	/**
	 * 操作人
	 */
	private String operator;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getGoodsId() {
		return goodsId;
	}

	public void setGoodsId(Long goodsId) {
		this.goodsId = goodsId;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getMerchantsId() {
		return merchantsId;
	}

	public void setMerchantsId(Long merchantsId) {
		this.merchantsId = merchantsId;
	}

	public Long getShopId() {
		return shopId;
	}

	public void setShopId(Long shopId) {
		this.shopId = shopId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getItemUrl() {
		return itemUrl;
	}

	public void setItemUrl(String itemUrl) {
		this.itemUrl = itemUrl;
	}

	public String getImgUrl() {
		return imgUrl;
	}

	public void setImgUrl(String imgUrl) {
		this.imgUrl = imgUrl;
	}

	public Integer getOriginalPrice() {
		return originalPrice;
	}

	public void setOriginalPrice(Integer originalPrice) {
		this.originalPrice = originalPrice;
	}

	public Integer getPreferPrice() {
		return preferPrice;
	}

	public void setPreferPrice(Integer preferPrice) {
		this.preferPrice = preferPrice;
	}

	public Integer getGoodsType() {
		return goodsType;
	}

	public void setGoodsType(Integer goodsType) {
		this.goodsType = goodsType;
	}

	public Integer getCategory() {
		return category;
	}

	public void setCategory(Integer category) {
		this.category = category;
	}

	public Long getStock() {
		return stock;
	}

	public void setStock(Long stock) {
		this.stock = stock;
	}

	public Integer getCommissionRate() {
		return commissionRate;
	}

	public void setCommissionRate(Integer commissionRate) {
		this.commissionRate = commissionRate;
	}

	public Integer getPlanType() {
		return planType;
	}

	public void setPlanType(Integer planType) {
		this.planType = planType;
	}

	public String getPlanName() {
		return planName;
	}

	public void setPlanName(String planName) {
		this.planName = planName;
	}

	public String getPlanUrl() {
		return planUrl;
	}

	public void setPlanUrl(String planUrl) {
		this.planUrl = planUrl;
	}

	public Integer getGoodsStatus() {
		return goodsStatus;
	}

	public void setGoodsStatus(Integer goodsStatus) {
		this.goodsStatus = goodsStatus;
	}

	public String getReasonMsg() {
		return reasonMsg;
	}

	public void setReasonMsg(String reasonMsg) {
		this.reasonMsg = reasonMsg;
	}

	public String getCouponId() {
		return couponId;
	}

	public void setCouponId(String couponId) {
		this.couponId = couponId;
	}

	public Date getSubmitTime() {
		return submitTime;
	}

	public void setSubmitTime(Date submitTime) {
		this.submitTime = submitTime;
	}

	public Date getEffectiveStartTime() {
		return effectiveStartTime;
	}

	public void setEffectiveStartTime(Date effectiveStartTime) {
		this.effectiveStartTime = effectiveStartTime;
	}

	public Date getEffectiveEndTime() {
		return effectiveEndTime;
	}

	public void setEffectiveEndTime(Date effectiveEndTime) {
		this.effectiveEndTime = effectiveEndTime;
	}

	public Date getPlanStartTime() {
		return planStartTime;
	}

	public void setPlanStartTime(Date planStartTime) {
		this.planStartTime = planStartTime;
	}

	public Date getPlanEndTime() {
		return planEndTime;
	}

	public void setPlanEndTime(Date planEndTime) {
		this.planEndTime = planEndTime;
	}

	public Date getEnableScheduleStartTime() {
		return enableScheduleStartTime;
	}

	public void setEnableScheduleStartTime(Date enableScheduleStartTime) {
		this.enableScheduleStartTime = enableScheduleStartTime;
	}

	public Date getEnableScheduleEndTime() {
		return enableScheduleEndTime;
	}

	public void setEnableScheduleEndTime(Date enableScheduleEndTime) {
		this.enableScheduleEndTime = enableScheduleEndTime;
	}

	public Date getFinalScheduleStartTime() {
		return finalScheduleStartTime;
	}

	public void setFinalScheduleStartTime(Date finalScheduleStartTime) {
		this.finalScheduleStartTime = finalScheduleStartTime;
	}

	public Date getFinalScheduleEndTime() {
		return finalScheduleEndTime;
	}

	public void setFinalScheduleEndTime(Date finalScheduleEndTime) {
		this.finalScheduleEndTime = finalScheduleEndTime;
	}

	public Date getScheduleStartTime() {
		return scheduleStartTime;
	}

	public void setScheduleStartTime(Date scheduleStartTime) {
		this.scheduleStartTime = scheduleStartTime;
	}

	public Date getScheduleEndTime() {
		return scheduleEndTime;
	}

	public void setScheduleEndTime(Date scheduleEndTime) {
		this.scheduleEndTime = scheduleEndTime;
	}

	public String getCouponUrl() {
		return couponUrl;
	}

	public void setCouponUrl(String couponUrl) {
		this.couponUrl = couponUrl;
	}

	public Integer getPlatformType() {
		return platformType;
	}

	public void setPlatformType(Integer platformType) {
		this.platformType = platformType;
	}

	public Long getVolume() {
		return volume;
	}

	public void setVolume(Long volume) {
		this.volume = volume;
	}

	public Integer getFinalPrice() {
		return finalPrice;
	}

	public void setFinalPrice(Integer finalPrice) {
		this.finalPrice = finalPrice;
	}

	public String getAuditor() {
		return auditor;
	}

	public void setAuditor(String auditor) {
		this.auditor = auditor;
	}

	public String getShopName() {
		return shopName;
	}

	public void setShopName(String shopName) {
		this.shopName = shopName;
	}

	public String getShopWangwang() {
		return shopWangwang;
	}

	public void setShopWangwang(String shopWangwang) {
		this.shopWangwang = shopWangwang;
	}

	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}
}
