package com.maila88.modules.merchants.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;

import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.merchants.dto.Maila88MerchantsGoodsDto;
import com.maila88.modules.merchants.dto.Maila88MerchantsGoodsQryDto;
import com.maila88.modules.merchants.dto.MailaMerchantsGoodsAuditDto;

/**
 * 管理员后台商家商品
 * Author: zhanghuifeng
 * Date:   17:01 2017/4/24
 */
@AdvancedFeignClient
public interface RemoteMaila88MerchantsGoodsBackendService {
	/**
	 * 根据商品类型、所属类目、商品id、商品标题、审核状态查询商家商品数据（分页）
	 *
	 * @param maila88MerchantsGoodsQryDto 商家商品查询参数
	 * @return List<MailaMerchantsGoodsDto>
	 */
	DubboResult<Maila88PageDto<Maila88MerchantsGoodsDto>> findByPage(Maila88MerchantsGoodsQryDto maila88MerchantsGoodsQryDto);

	/**
	 * 管理员后台商家商品审核
	 * @param mailaMerchantsGoodsDto 商家商品审核数据
	 * @return Boolean
	 */
	DubboResult<Boolean> audit(MailaMerchantsGoodsAuditDto mailaMerchantsGoodsDto);

	/**
	 * 根据goodsId查询商家商品信息
	 * @param goodsId 商品goodsId
	 * @return MailaMerchantsGoodsDto
	 */
	DubboResult<Maila88MerchantsGoodsDto> findByGoodsId(Long goodsId);

	/**
	 * 待审核商品中是否已存在有效期有冲突的商品
	 * @param itemId         商品itemid
	 * @param autoStartTime  生效时间
	 * @param autoEndTime    失效时间
	 * @return Boolean
	 */
	DubboResult<Boolean> isExistMerchantsGoods(Long itemId, Date autoStartTime, Date autoEndTime);
}
