package com.maila88.modules.odps.dto;

import com.maila88.modules.odps.enums.Maila88AutoReportFileStatusEnum;
import com.maila88.modules.odps.enums.Maila88AutoReportFileTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by peanut.huang on 2017/7/14.
 */
public class Maila88AutoReportDto implements Serializable {
    private static final long serialVersionUID = 1087611417411335804L;

    /**
     * 未入库文件名称
     */
    private String readyFileName;

    /**
     * 入库文件名称
     */
    private String reportedFileName;

    /**
     * 文件类型 {@link Maila88AutoReportFileTypeEnum#id}
     */
    private Integer fileType;

    /**
     * 文件类型名称
     */
    private String fileTypeName;

    /**
     * 文件状态 {@link Maila88AutoReportFileStatusEnum#id}
     */
    private Integer fileStatus;

    /**
     * 文件隶属日期
     */
    private Date belongDate;

    public String getReadyFileName() {
        return readyFileName;
    }

    public void setReadyFileName(String readyFileName) {
        this.readyFileName = readyFileName;
    }

    public String getReportedFileName() {
        return reportedFileName;
    }

    public void setReportedFileName(String reportedFileName) {
        this.reportedFileName = reportedFileName;
    }

    public Integer getFileType() {
        return fileType;
    }

    public void setFileType(Integer fileType) {
        this.fileType = fileType;
    }

    public String getFileTypeName() {
        return fileTypeName;
    }

    public void setFileTypeName(String fileTypeName) {
        this.fileTypeName = fileTypeName;
    }

    public Date getBelongDate() {
        return belongDate;
    }

    public void setBelongDate(Date belongDate) {
        this.belongDate = belongDate;
    }

    public Integer getFileStatus() {
        return fileStatus;
    }

    public void setFileStatus(Integer fileStatus) {
        this.fileStatus = fileStatus;
    }
}
