package com.maila88.modules.odps.enums;


import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 报表文件类型
 * Created by peanut.huang on 2017/7/14.
 */
public enum Maila88AutoReportFileTypeEnum {


    //以下为日报类型

    ALIMAMA_RIGHTS(1,"阿里妈妈权益"),

    ALIMAMA_CLICK(2,"阿里妈妈点击"),

    QIHO_ORDER(3,"货到付款"),

    QIHO_GOODSNUM_REBATE(4,"货号与返点"),


    BAI_KE_GOU(8,"百客购"),

    CASHONDELIVERY_BOSS_JIN(9,"货到付款-金老板"),

    DANFEI(10,"单费"),


    //以下为月报类型

    ALIMAMA_MONTH_SAFEGUARD(5,"阿里妈妈月度维权"),

    RIGHTS_MONTH_SETTLE(6,"权益月度结算"),

    RIGHTS_MONTH_SAFEGUARD(7,"权益月度维权");

    //

    private int id;

    private String name;

    Maila88AutoReportFileTypeEnum(int id, String name){
        this.id = id;
        this.name = name;
    }

    /**
     * 根据id查询文件类型
     *
     * @param id
     * @return
     */
    public static Maila88AutoReportFileTypeEnum findById(Integer id){
        if(id == null || id <= 0){
            return null;
        }

        List<Maila88AutoReportFileTypeEnum> enumList = Arrays.asList(Maila88AutoReportFileTypeEnum.values());

        return enumList.stream().filter(e -> e.getId() == id).findFirst().orElse(null);
    }

    /**
     * 根据ids查询文件类型
     *
     * @param ids
     * @return
     */
    public static List<Maila88AutoReportFileTypeEnum> findByIds(List<Integer> ids){
        if(CollectionUtils.isEmpty(ids)){
            return Collections.emptyList();
        }

        List<Maila88AutoReportFileTypeEnum> enumList = Arrays.asList(Maila88AutoReportFileTypeEnum.values());

        return enumList.stream().filter(e->ids.contains(e.getId())).collect(Collectors.toList());
    }

    /**
     * 根据报表类型获取该类型下的报表文件类型id集
     *
     * @param reportType 报表类型 {@link Maila88AutoReportTypeEnum#id}
     * @return
     */
    public static List<Integer> findIdsByReportType(Integer reportType){
        if(reportType == null || reportType <= 0){
            return Collections.emptyList();
        }

        Maila88AutoReportTypeEnum reportTypeEnum = Maila88AutoReportTypeEnum.findById(reportType);
        if(reportTypeEnum == null){
            return Collections.emptyList();
        }
        List<Integer> ids = new ArrayList<>();
        switch (reportTypeEnum){
            case DAILY:
                ids.add(Maila88AutoReportFileTypeEnum.ALIMAMA_RIGHTS.getId());
                ids.add(Maila88AutoReportFileTypeEnum.ALIMAMA_CLICK.getId());
                ids.add(Maila88AutoReportFileTypeEnum.QIHO_ORDER.getId());
                ids.add(Maila88AutoReportFileTypeEnum.QIHO_GOODSNUM_REBATE.getId());
                ids.add(Maila88AutoReportFileTypeEnum.BAI_KE_GOU.getId());
                ids.add(Maila88AutoReportFileTypeEnum.CASHONDELIVERY_BOSS_JIN.getId());
                ids.add(Maila88AutoReportFileTypeEnum.DANFEI.getId());
                break;
            case MONTH:
                ids.add(Maila88AutoReportFileTypeEnum.ALIMAMA_MONTH_SAFEGUARD.getId());
                ids.add(Maila88AutoReportFileTypeEnum.RIGHTS_MONTH_SETTLE.getId());
                ids.add(Maila88AutoReportFileTypeEnum.RIGHTS_MONTH_SAFEGUARD.getId());
                break;
            default:
                break;
        }
        return ids;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }
}
