package com.maila88.modules.order.enums;

import java.util.Arrays;
import java.util.Collection;

import com.google.common.collect.Collections2;

/**
 * 异常订单状态
 * Author: zhanghuifeng
 * Date:   14:16 2017/6/29
 */
public enum Maila88ProcessStatusEnum {
	DEALT(1,"已处理"),
	NOT_DEAL(0,"未处理"),
	AUTO_INVALID(2,"系统下架");

	private int status;

	private String name;

	Maila88ProcessStatusEnum(int status, String name){
		this.status = status;
		this.name = name;
	}

	public int getStatus() {
		return status;
	}

	public String getName() {
		return name;
	}

	public static String getByStatus(final int status) {
		Collection<Maila88ProcessStatusEnum> result = Collections2.filter(Arrays.asList(Maila88ProcessStatusEnum.values()), gs -> {
			assert gs != null;
			return gs.getStatus() == status;
		});
		return result.isEmpty() ? "" : result.iterator().next().getName();
	}
}
