package com.maila88.modules.order.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.maila88.modules.order.dto.Maila88AnormalOrdersGroupDto;
import com.maila88.modules.order.dto.MailaAnormalOrderOperateQueryBeanDto;
import com.maila88.modules.order.dto.MailaAnormalOrderQueryBeanDto;

import java.util.List;

/**
 * Created by johnkeng on 2017/6/7.
 */
@AdvancedFeignClient
public interface RemoteMailaAnormalOrderService {

    DubboResult<List<Maila88AnormalOrdersGroupDto>> searchNormalOrder(MailaAnormalOrderQueryBeanDto mailaAnormalOrderQueryBeanDto);

    DubboResult<Long> searchNormalOrderCount(MailaAnormalOrderQueryBeanDto mailaAnormalOrderQueryBeanDto);

    DubboResult<Boolean> operate(List<MailaAnormalOrderOperateQueryBeanDto> queryBeanList);

    /**
     * 批量更新
     * @param ids        主键id集合
     * @param note       处理意见
     * @param processor  处理人
     * @return boolean
     */
    DubboResult<Boolean> batchOperate(List<Long> ids, String note, String processor);

    /**
     * 查询未处理异常订单
     * @param query 参数
     * @return id集合
     */
    DubboResult<List<Long>> findUnDealIds(MailaAnormalOrderQueryBeanDto query);
}
