package com.maila88.modules.rob.params;

import com.maila.biz.center.api.enums.GoodsSpecialStatus;

import java.io.Serializable;
import java.util.Date;

/**
 * 抢购商品分页查询对象参数
 *
 * Created by peanuthuang on 2017/5/4.
 */
public class Maila88RobGoodsQueryParam implements Serializable{

    private static final long serialVersionUID = -4535998009063041533L;

    /**
     * 商品名称
     */
    private String name4admin;

    /**
     * 商品标题
     */
    private String title;

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * 淘宝商品ID
     */
    private Long itemId;

    /**
     * 商品状态:待上架，已上架，已下架 {@link GoodsSpecialStatus}
     */
    private Integer goodsStatus;

    /**
     * 上架开始时间
     */
    private Date autoEnableStartTime;

    /**
     * 上架结束时间
     */
    private Date autoEnableEndTime;

    /**
     * 下架开始时间
     */
    private Date autoDisableStartTime;

    /**
     * 下架结束时间
     */
    private Date autoDisableEndTime;

    /**
     *  偏移量
     */
    private Integer offset;

    /**
     * 每页条数
     */
    private Integer pageSize;

    public Maila88RobGoodsQueryParam() {
        super();
    }

    public String getName4admin() {
        return name4admin;
    }

    public void setName4admin(String name4admin) {
        this.name4admin = name4admin;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getGoodsStatus() {
        return goodsStatus;
    }

    public void setGoodsStatus(Integer goodsStatus) {
        this.goodsStatus = goodsStatus;
    }

    public Date getAutoEnableStartTime() {
        return autoEnableStartTime;
    }

    public void setAutoEnableStartTime(Date autoEnableStartTime) {
        this.autoEnableStartTime = autoEnableStartTime;
    }

    public Date getAutoEnableEndTime() {
        return autoEnableEndTime;
    }

    public void setAutoEnableEndTime(Date autoEnableEndTime) {
        this.autoEnableEndTime = autoEnableEndTime;
    }

    public Date getAutoDisableStartTime() {
        return autoDisableStartTime;
    }

    public void setAutoDisableStartTime(Date autoDisableStartTime) {
        this.autoDisableStartTime = autoDisableStartTime;
    }

    public Date getAutoDisableEndTime() {
        return autoDisableEndTime;
    }

    public void setAutoDisableEndTime(Date autoDisableEndTime) {
        this.autoDisableEndTime = autoDisableEndTime;
    }

    public Integer getOffset() {
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
