package com.maila88.modules.rob.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.rob.dto.Maila88SceneDto;
import com.maila88.modules.rob.dto.Maila88SceneSelectDto;

import java.util.List;

/**
 * Created by gyf .
 * 2017/5/10 .
 */
@AdvancedFeignClient
public interface RemoteMaila88AppSceneBackendService {

    /**
     * 根据 appId 获取场次
     * @param appId
     * @return
     */
    DubboResult<List<Maila88SceneDto>> findSceneByAppId(Long appId);

    /**
     * 移除已失效
     * @param appId
     * @return
     */
    DubboResult<Boolean> deleteDisabled(Long appId);

    /**
     * 删除 id
     * @param appId
     * @param sceneId
     * @return
     */
    DubboResult<Boolean> delete(Long appId, Long sceneId);

    /**
     * 根据 id 获取场次
     * @param sceneId
     * @return
     */
    DubboResult<Maila88SceneSelectDto> findSceneById(Long sceneId);

    /**
     * 根据 name 获取场次的数组
     * @param name
     * @return
     */
    DubboResult<List<Maila88SceneSelectDto>> findSceneByName(String name);

    /**
     * 把场次添加到 app 中
     * @param sceneId
     * @param appId
     * @return
     */
    DubboResult<Long> addSceneIntoApp(Long sceneId, Long appId);

    /**
     * 根据场次id查询应用id集合
     * @param sceneId 场次id
     * @return 应用id集合
     */
    DubboResult<List<Long>> findAppIdsBySceneId(Long sceneId);

    /**
     * 单个应用添加多个场次
     * @param sceneIds  场次id
     * @param appId     应用id
     * @return Boolean
     */
    DubboResult<Boolean> addScenesIntoApp(List<Long> sceneIds, Long appId);

    /**
     * 根据场次id或name查询应用下可添加的场次列表
     * @param appId          应用id
     * @param sceneIdOrName  id或name
     * @return 场次列表
     */
    DubboResult<List<Maila88SceneSelectDto>> findCanAddScenesByAppId(Long appId,String sceneIdOrName);
}
