package com.maila88.modules.rob.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.rob.dto.Maila88RobGoodsPageDto;
import com.maila88.modules.rob.dto.Maila88SceneDto;

import java.util.List;

/**
 * Created by peanuthuang on 2017/5/5.
 */
@AdvancedFeignClient
public interface RemoteMaila88SceneBackendService {

    /**
     * 新增场次
     *
     * @param sceneDto
     * @return 返回新增后的记录id
     */
    DubboResult<Long> insert(Maila88SceneDto sceneDto);

    /**
     * 更新场次
     *
     * @param sceneDto
     * @return
     */
    DubboResult<Boolean> update(Maila88SceneDto sceneDto);

    /**
     * 删除场次
     *
     * @param sceneId 场次id
     * @return
     */
    DubboResult<Boolean> delete(Long sceneId);

    /**
     * 场次生效
     *
     * @param sceneId 场次id
     * @return
     */
    DubboResult<Boolean> enable(Long sceneId);

    /**
     * 场次失效
     *
     * @param sceneId 场次id
     * @return
     */
    DubboResult<Boolean> disable(Long sceneId);

    /**
     * 分页查询场次列表
     *
     * @param sceneId    场次id
     * @param sceneName  场次名称
     * @param offset
     * @param pageSize
     * @return
     */
    DubboResult<Maila88PageDto<Maila88SceneDto>> find4Page(Long sceneId, String sceneName, Integer offset, Integer pageSize);

    /**
     * 根据 id 查询
     * @param id
     * @return
     */
    DubboResult<Maila88SceneDto> findById(Long id);

    /**
     * 把商品插入到场次中
     * @param goodsId
     * @param sceneId
     * @return
     */
    DubboResult<Long> addGoodsIntoScene(Long goodsId, Long sceneId);

    /**
     * 批量排序
     * @param goodsIds
     * @param sceneId
     * @return
     */
    DubboResult<Boolean> sortGoodsByGoodsIds(List<Long> goodsIds, Long sceneId);

    /**
     * 删除单个商品关联
     * @param id
     * @return
     */
    DubboResult<Boolean> deleteGoods(Long sceneId, Long goodsId);

    /**
     * 批量删除商品关联
     * @param ids
     * @return
     */
    DubboResult<Boolean> deleteGoodss(Long sceneId, List<Long> goodsIds);

    /**
     * 根据场次获取抢购商品数组
     * @param sceneId
     * @return
     */
    DubboResult<List<Maila88RobGoodsPageDto>> findRobGoodsBySceneId(Long sceneId);

    /**
     * 单个抢购场次进多个应用
     * @param appIds  应用id
     * @param sceneId 场次id
     * @return boolean
     */
    DubboResult<Boolean> pushSingleIntoApps(List<Long> appIds, Long sceneId);

    /**
     * 多个抢购场次进多个应用
     * @param appIds    应用ID
     * @param sceneIds 场次ID
     * @return boolean
     */
    DubboResult<Boolean> batchPushIntoApps(List<Long> appIds, List<Long> sceneIds);

    /**
     * 批量商品进抢购场次
     * @param goodsIds
     * @param sceneId
     * @return
     */
    DubboResult<Boolean> addGoodsList2Scene(List<Long> goodsIds, Long sceneId);

    /**
     * 管理员端 更改场次下 为个性化的limitPv 和 goodsPv 需要发异步事件
     * @param sceneId
     * @param limitPv
     * @return
     */
    DubboResult<Boolean> updateDefaultRobGoods(Long sceneId, Long limitPv, Maila88SceneDto sceneDto);
}
