package com.maila88.modules.special.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 功能描述:提供给手机端商品DTO对象
 *
 * @author sunchangji
 * @date 2016/11/11
 */
public class Maila88AppSpecialGoodsDto implements Serializable {

	private static final long serialVersionUID = -233738767892957784L;
	/**
	 * 主键id
	 */
	private Long id;
	/**
	 *商品id
	 */
	private Long goodsId;

	/**淘宝商品id**/
	private Long itemId;

	/**
	 * 手机端显示商品名称
	 */
	private String title;

	/**
	 * 商品类型:淘宝itemId,url @See MailaGoodsType
	 */
	private Integer goodsType;

	/**
	 * 商品内容，根据goodsType变化，itemId,URL @See MailaGoodsType
	 *
	 * goodsType为1则为URL,为2则为淘宝itemId
	 */
	private String goodsContent;

	/**
	 * 商品原价
	 */
	private Integer originalPrice;

	/**
	 * 商品优惠价
	 */
	private Integer preferPrice;

	/**
	 * 商品标签,例：包邮
	 */
	private String tag;

	/**
	 * 商品图地址
	 */
	private String imgUrl;

	/**
	 * 商品已购数量
	 */
	private Long saleCount;

	/**
	 * 商品个性化副标题
	 */
	private String subTitle;

	/**
	 * 商品图片角标
	 */
	private String cornerImgUrl;

	/**平台标识(-1:其他 0:淘宝,1:天猫)**/
	private Integer platformType;

	/**
	 * 商品排期开始时间
	 */
	private Date scheduleStartTime;

	/**
	 * 商品排期结束时间
	 */
	private Date scheduleEndTime;

	/**商品现价**/
	private Integer finalPrice;

	/**
	 * 兑吧类型应用下商品的个性化信息
	 * json字符串(credits:积分价值)
	 */
	private String duibaInfo;

	/**
	 * 倒计时开关
	 */
	private Integer countDown;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getGoodsType() {
		return goodsType;
	}

	public void setGoodsType(Integer goodsType) {
		this.goodsType = goodsType;
	}

	public String getGoodsContent() {
		return goodsContent;
	}

	public void setGoodsContent(String goodsContent) {
		this.goodsContent = goodsContent;
	}

	public Integer getOriginalPrice() {
		return originalPrice;
	}

	public void setOriginalPrice(Integer originalPrice) {
		this.originalPrice = originalPrice;
	}

	public Integer getPreferPrice() {
		return preferPrice;
	}

	public void setPreferPrice(Integer preferPrice) {
		this.preferPrice = preferPrice;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public String getImgUrl() {
		return imgUrl;
	}

	public void setImgUrl(String imgUrl) {
		this.imgUrl = imgUrl;
	}

	public Long getSaleCount() {
		return saleCount;
	}

	public void setSaleCount(Long saleCount) {
		this.saleCount = saleCount;
	}

	public Long getGoodsId() {
		return goodsId;
	}

	public void setGoodsId(Long goodsId) {
		this.goodsId = goodsId;
	}

	public Date getScheduleStartTime() {
		return scheduleStartTime;
	}

	public void setScheduleStartTime(Date scheduleStartTime) {
		this.scheduleStartTime = scheduleStartTime;
	}

	public Date getScheduleEndTime() {
		return scheduleEndTime;
	}

	public void setScheduleEndTime(Date scheduleEndTime) {
		this.scheduleEndTime = scheduleEndTime;
	}

	public String getSubTitle() {
		return subTitle;
	}

	public void setSubTitle(String subTitle) {
		this.subTitle = subTitle;
	}

	public String getCornerImgUrl() {
		return cornerImgUrl;
	}

	public void setCornerImgUrl(String cornerImgUrl) {
		this.cornerImgUrl = cornerImgUrl;
	}

	public Integer getPlatformType() {
		return platformType;
	}

	public void setPlatformType(Integer platformType) {
		this.platformType = platformType;
	}

	public Integer getFinalPrice() {
		return finalPrice;
	}

	public void setFinalPrice(Integer finalPrice) {
		this.finalPrice = finalPrice;
	}

	public String getDuibaInfo() {
		return duibaInfo;
	}

	public void setDuibaInfo(String duibaInfo) {
		this.duibaInfo = duibaInfo;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Integer getCountDown() {
		return countDown;
	}

	public void setCountDown(Integer countDown) {
		this.countDown = countDown;
	}
}
