package com.maila88.modules.special.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.common.dto.Maila88SelectDto;
import com.maila88.modules.special.dto.Maila88SpecialDto;
import com.maila88.modules.special.dto.Maila88SpecialGoodsDto;
import com.maila88.modules.special.dto.Maila88SpecialIdAndNameDto;

import java.util.List;

/**
 * Created by sunchangji on 2017/6/26.
 */
@AdvancedFeignClient
public interface RemoteMaila88SpecialBackendService {
    /**
     * 根据名称模糊查询专场 （分页查询）
     *
     * @param name4admin 管理员后台专场名称
     * @param title      专场标题
     * @param offset     偏移量
     * @param pageSize   每页数量
     * @return 专场列表集
     */
    DubboResult<Maila88PageDto<Maila88SpecialDto>> find4Page(String name4admin, String title, Integer offset, Integer pageSize);

    /**
     * 添加麦啦专场
     *
     * @param maila88SpecialDto 参数
     * @return Boolean
     */
    DubboResult<Boolean> addMailaSpecial(Maila88SpecialDto maila88SpecialDto);

    /**
     * 更新麦啦专场
     *
     * @param maila88SpecialDto 参数
     * @return Boolean
     */
    DubboResult<Boolean> updateMailaSpecial(Maila88SpecialDto maila88SpecialDto);

    /**
     * 删除专场
     *
     * @param specialId
     * @return
     */
    DubboResult<Boolean> deleteMailaSpecial(Long specialId);

    /**
     * 根据专场id查询商品
     *
     * @param specialId 专场id
     * @return
     */
    DubboResult<List<Maila88SpecialGoodsDto>> findSpecialGoods(Long specialId);

    /**
     * 根据名称或id查询所有专场
     *
     * @param value 名称或id
     * @return
     */
    DubboResult<List<Maila88SelectDto>> findSpecialByNameOrId(String value);

    /**
     * 根据专场id查询专场
     *
     * @param specialId 专场id
     * @return
     */
    DubboResult<Maila88SpecialDto> findById(Long specialId);

    /**
     * 删除专场下多个商品
     *
     * @param specialId 专场id
     * @param goodsIds  商品id
     * @return
     */
    DubboResult<Boolean> deleteByIdAndGoodsIds(Long specialId, String goodsIds);

    /**
     * 多个商品添加单个专场
     *
     * @param goodsIds  商品id集
     * @param specialId 专场id
     * @return
     */
    DubboResult<Boolean> addSpecialGoods(Long specialId, String goodsIds);

    /**
     * 专场进应用
     *
     * @param specialId 专场id
     * @param appIds    应用id
     * @return
     */
    DubboResult<Boolean> addAppSpecial(Long specialId, List<Long> appIds);

    /**
     * 主库专场失效
     *
     * @param specialId 专场id
     * @return
     */
    DubboResult<Boolean> disabledSpecial(Long specialId);

    /**
     * 多个商品添加至专场
     *
     * @param specialId           专场id
     * @param goodsIdsOrItemIds   有序的商品id或淘宝商品ID集合，例:1,2,3,4
     * @param goodsIdOrItemIdType See GoodsIdOrItemIdTypeEnum
     * @return Boolean
     */
    DubboResult<Boolean> batchAddSpecialGoods(Long specialId, String goodsIdsOrItemIds, int goodsIdOrItemIdType);

    /**
     * 批量对专场下商品进行排序
     *
     * @param specialId           专场id
     * @param goodsIdsOrItemIds   有序的商品id或淘宝商品ID集合，例:1,2,3,4
     * @param goodsIdOrItemIdType See GoodsIdOrItemIdTypeEnum
     * @return Boolean
     */
    DubboResult<Boolean> batchSortGoods(Long specialId, String goodsIdsOrItemIds, int goodsIdOrItemIdType);

    /**
     * 移除专场库中已失效商品
     *
     * @param specialId 专场ID
     * @return Boolean
     */
    DubboResult<Boolean> deleteInvalidSpecialGoods(Long specialId);


    /**
     * 获取专场id和名称列表数据
     *
     * @return
     */
    DubboResult<List<Maila88SpecialIdAndNameDto>> findSpecialIdAndName();


    /**
     * 获取专场id集获取专场
     *
     * @param specialIds  专场id集
     * @return
     */
    DubboResult<List<Maila88SpecialDto>> findBySpecialIds(List<Long> specialIds);

}
