package com.maila88.modules.tab.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 公共tab内容dto
 *
 * Created by peanut.huang on 2017/6/26.
 */
public class Maila88PublicTabContentDto implements Serializable {

    private static final long serialVersionUID = -5475128982580937208L;

    /**
     * 内容表记录id，用于分页
     */
    private Long id;

    /**
     * 内容类型
     */
    private Integer relationType;

    /**
     * 内容类型值
     */
    private String relationTypeName;

    /**
     * 内容id
     */
    private Long relationId;

    /**
     * 淘宝商品id
     **/
    private Long itemId;

    /**
     * 商品图地址
     */
    private String imgUrl;

    /**
     * 管理后台显示商品名称
     */
    private String relationName;

    /**
     * 手机端显示商品名称
     */
    private String relationTitle;

    /**
     * 优惠券详细信息链接地址
     **/
    private String couponUrl;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * 商品类型:淘宝itemId,url @See MailaGoodsType
     */
    private String goodsTypeName;

    /**
     * 商品优惠价
     */
    private Integer preferPrice;

    /**
     * 商品现价
     **/
    private Integer finalPrice;

    /**
     * 类目
     */
    private Integer category;

    /**
     * 类目id(1女装,2男装,3鞋包,4内衣,5饰品,6运动,7美妆,8童装,
     * 9食品,10母婴,11百货,12汽车,13家电,14数码,15家装,16家纺,17其他)
     **/
    private String categoryName;

    /**
     * 商品状态值:待上架，已上架，已下架 @See GoodsSpecialStatus
     */
    private Integer relationStatus;

    /**
     * 商品状态值:待上架，已上架，已下架 @See GoodsSpecialStatus
     */
    private String relationStatusName;

    /**
     * 自动启动时间
     */
    private Date autoStartTime;

    /**
     * 自动结束时间
     */
    private Date autoEndTime;

    /**
     * 是否占坑
     */
    private Boolean position;

    /**
     * 30天销量
     */
    private Long volume;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getRelationType() {
        return relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getRelationName() {
        return relationName;
    }

    public void setRelationName(String relationName) {
        this.relationName = relationName;
    }

    public String getRelationTitle() {
        return relationTitle;
    }

    public void setRelationTitle(String relationTitle) {
        this.relationTitle = relationTitle;
    }

    public String getCouponUrl() {
        return couponUrl;
    }

    public void setCouponUrl(String couponUrl) {
        this.couponUrl = couponUrl;
    }

    public Integer getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(Integer goodsType) {
        this.goodsType = goodsType;
    }

    public Integer getPreferPrice() {
        return preferPrice;
    }

    public void setPreferPrice(Integer preferPrice) {
        this.preferPrice = preferPrice;
    }

    public Integer getFinalPrice() {
        return finalPrice;
    }

    public void setFinalPrice(Integer finalPrice) {
        this.finalPrice = finalPrice;
    }

    public Integer getCategory() {
        return category;
    }

    public void setCategory(Integer category) {
        this.category = category;
    }

    public Integer getRelationStatus() {
        return relationStatus;
    }

    public void setRelationStatus(Integer relationStatus) {
        this.relationStatus = relationStatus;
    }

    public String getRelationStatusName() {
        return relationStatusName;
    }

    public void setRelationStatusName(String relationStatusName) {
        this.relationStatusName = relationStatusName;
    }

    public Date getAutoStartTime() {
        return autoStartTime;
    }

    public void setAutoStartTime(Date autoStartTime) {
        this.autoStartTime = autoStartTime;
    }

    public Date getAutoEndTime() {
        return autoEndTime;
    }

    public void setAutoEndTime(Date autoEndTime) {
        this.autoEndTime = autoEndTime;
    }

    public Boolean getPosition() {
        return position;
    }

    public void setPosition(Boolean position) {
        this.position = position;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getRelationTypeName() {
        return relationTypeName;
    }

    public void setRelationTypeName(String relationTypeName) {
        this.relationTypeName = relationTypeName;
    }

    public String getGoodsTypeName() {
        return goodsTypeName;
    }

    public void setGoodsTypeName(String goodsTypeName) {
        this.goodsTypeName = goodsTypeName;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Long getVolume() {
        return volume;
    }

    public void setVolume(Long volume) {
        this.volume = volume;
    }
}
