package com.maila88.modules.tab.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * tab下商品实体数据对象
 * Created by sunchangji on 2017/6/6.
 */
public class Maila88TabGoodsAndSpecialDto implements Serializable {
    private static final long serialVersionUID = -2190883414744651757L;
    /**
     * 中间表id
     */
    private Long id;
    /**
     * 应用id
     */
    private Long appId;

    private Long tabId;
    /**
     * 关联id(专场id或商品id)
     */
    private Long relationId;
    /**
     * 类型 @see RelationType
     */
    private Integer relationType;

    /**商品类型(1:优惠券,2:优惠价)**/
    private Integer goodsType;

    /**商品类型名称(1:优惠券,2:优惠价)**/
    private String goodsTypeName;

    /**
     * 关联商品或者专场的名称
     */
    private String relationName;

    /**
     * 关联商品或者专场的标题
     */
    private String relationTitle;

    /**
     * 关联状态
     */
    private String relationStatusName;

    /**优惠券详细信息链接地址**/
    private String couponUrl;

    /**
     * 类型为商品的主图
     */
    private String imgUrl;

    /**
     * 商品优惠价
     */
    private Integer preferPrice;
    /**
     * 有效期开始时间
     */
    private Date scheduleStartTime;
    /**
     * 有效期结束时间
     */
    private Date scheduleEndTime;
    /**
     * 上架周期开始时间
     */
    private Date autoStartTime;
    /**
     * 上架周期结束时间
     */
    private Date autoEndTime;
    /**
     * 淘宝商品id
     */
    private Long itemId;
    /**
     * 商品类目名称
     */
    private String categoryName;

    /**商品现价**/
    private Integer finalPrice;

    /**
     *30天销量
     */
    private Long volume;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getTabId() {
        return tabId;
    }

    public void setTabId(Long tabId) {
        this.tabId = tabId;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public Integer getRelationType() {
        return relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public Integer getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(Integer goodsType) {
        this.goodsType = goodsType;
    }

    public String getGoodsTypeName() {
        return goodsTypeName;
    }

    public void setGoodsTypeName(String goodsTypeName) {
        this.goodsTypeName = goodsTypeName;
    }

    public String getRelationName() {
        return relationName;
    }

    public void setRelationName(String relationName) {
        this.relationName = relationName;
    }

    public String getRelationTitle() {
        return relationTitle;
    }

    public void setRelationTitle(String relationTitle) {
        this.relationTitle = relationTitle;
    }

    public String getRelationStatusName() {
        return relationStatusName;
    }

    public void setRelationStatusName(String relationStatusName) {
        this.relationStatusName = relationStatusName;
    }

    public String getCouponUrl() {
        return couponUrl;
    }

    public void setCouponUrl(String couponUrl) {
        this.couponUrl = couponUrl;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Integer getPreferPrice() {
        return preferPrice;
    }

    public void setPreferPrice(Integer preferPrice) {
        this.preferPrice = preferPrice;
    }

    public Date getScheduleStartTime() {
        return scheduleStartTime;
    }

    public void setScheduleStartTime(Date scheduleStartTime) {
        this.scheduleStartTime = scheduleStartTime;
    }

    public Date getScheduleEndTime() {
        return scheduleEndTime;
    }

    public void setScheduleEndTime(Date scheduleEndTime) {
        this.scheduleEndTime = scheduleEndTime;
    }

    public Date getAutoStartTime() {
        return autoStartTime;
    }

    public void setAutoStartTime(Date autoStartTime) {
        this.autoStartTime = autoStartTime;
    }

    public Date getAutoEndTime() {
        return autoEndTime;
    }

    public void setAutoEndTime(Date autoEndTime) {
        this.autoEndTime = autoEndTime;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Integer getFinalPrice() {
        return finalPrice;
    }

    public void setFinalPrice(Integer finalPrice) {
        this.finalPrice = finalPrice;
    }

    public Long getVolume() {
        return volume;
    }

    public void setVolume(Long volume) {
        this.volume = volume;
    }

}
