package com.maila88.modules.tab.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88BusinessMsgDto;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.tab.dto.Maila88PublicTabDto;
import com.maila88.modules.tab.dto.Maila88PublicTabInAppDto;
import com.maila88.modules.tab.param.Maila88PublicTabPageQryParam;

import java.util.List;

/**
 * Created by peanut.huang on 2017/6/20.
 */
@AdvancedFeignClient
public interface RemoteMaila88PublicTabBackendService {

    /**
     * 公共tab分页列表
     *
     * @param pageQryParam
     * @return
     */
    DubboResult<Maila88PageDto<Maila88PublicTabDto>> find4Page(Maila88PublicTabPageQryParam pageQryParam);

    /**
     * 添加公共tab
     *
     * @param publicTabDto
     * @return
     */
    DubboResult<Boolean> insert(Maila88PublicTabDto publicTabDto);

    /**
     * 更新公共tab
     *
     * @param publicTabDto
     * @return
     */
    DubboResult<Boolean> update(Maila88PublicTabDto publicTabDto);

    /**
     * 删除公共tab
     *
     * @param publicTabId
     * @return
     */
    DubboResult<Boolean> delete(Long publicTabId);

    /**
     * 查询公共tab关联的应用tab
     *
     * @param publicTabId
     * @return
     */
    DubboResult<List<Maila88PublicTabInAppDto>> findAppTab(Long publicTabId);

    /**
     * 公共tab批量进多个应用
     *
     * @param publicTabId
     * @param appIds
     * @return
     */
    DubboResult<Maila88BusinessMsgDto> addApp(Long publicTabId, List<Long> appIds);

    /**
     * 更新公共tab状态
     * @param tabStatus 参见Maila88StatusEnum
     * @param id   公共tabId
     * @return int
     */
    DubboResult<Boolean> updateTabStatus(int tabStatus,Long id);

    /**
     * 用于应用下添加公共tab的下拉公共tab列表
     * 查询公共tab列表数据，排除应用下已经存在的公共tab
     * @param appId 应用id
     * @return
     */
    DubboResult<List<Maila88PublicTabDto>> findPublicTabs(Long appId);

    /**
     * 查询所有公共tab数据
     * @return
     */
    DubboResult<List<Maila88PublicTabDto>> findAllPublicTabs();

    DubboResult<Boolean>  saveAutoNewInfo(Long tabId,String autoNewTime,Integer isAutoNew,String tagIds,Integer isInclude);

    DubboResult<Maila88PublicTabDto>  findAutoNewInfo(Long tabId);
}
