package com.maila88.modules.tab.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88BusinessMsgDto;
import com.maila88.modules.tab.dto.Maila88PublicTabGoodsTempDto;

import java.util.List;

/**
 * 公共tab待选商品临时表服务
 *
 * Created by peanut.huang on 2017/6/21.
 */
@AdvancedFeignClient
public interface RemoteMaila88PublicTabGoodsTempBackendService {

    /**
     * 主库商品进待选临时表
     *
     * @param adminId    当前操作人id
     * @param goodsIds   主库商品id集
     * @return
     */
    Maila88BusinessMsgDto<Integer> packGoods(Long adminId, List<Long> goodsIds);

    /**
     * 获取待选商品总数
     *
     * @param adminId    当前操作人id
     * @return
     */
    DubboResult<Integer> getGoodsCount(Long adminId);

    /**
     * 删除待选商品
     *
     * @param adminId    当前操作人id
     * @param goodsId    要移除的商品id
     * @return
     */
    DubboResult<Boolean> deleteGoods(Long adminId, Long goodsId);

    /**
     * 分页待选商品列表
     *
     * @param adminId
     * @param offset
     * @param pageSize
     * @return
     */
    DubboResult<List<Maila88PublicTabGoodsTempDto>> listPageGoods(Long adminId, Integer offset, Integer pageSize);

    /**
     * 全部移除
     *
     * @param adminId
     * @return
     */
    DubboResult<Boolean> removeAllGoods(Long adminId);

    /**
     * 临时表商品批量进公共tab内容
     *
     * @param adminId
     * @param publicTabIds
     * @return
     */
    DubboResult<Boolean> saveGoods2Content(Long adminId, List<Long> publicTabIds);

    /**
     * 排序商品
     *
     * @param adminId
     * @return
     */
    DubboResult<Boolean> sortGoods(Long adminId, List<Long> goodsIds);

}
