package com.maila88.modules.tab.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88BusinessMsgDto;
import com.maila88.modules.tab.dto.Maila88PublicTabPositionDto;
import com.maila88.modules.tab.dto.Maila88PublicTabPositionTypeDto;
import com.maila88.modules.tab.dto.Maila88PublicTabRelationIdsAndTypeDto;

import java.util.List;

/**
 * 公共tab占坑服务
 *
 * Created by peanut.huang on 2017/6/21.
 */
@AdvancedFeignClient
public interface RemoteMaila88PublicTabPositionBackendService {

    /**
     * 占坑商品列表
     *
     * @param publicTabId
     * @param appId
     * @return
     */
    DubboResult<List<Maila88PublicTabPositionDto>> listPosition(Long publicTabId, Long appId);

    /**
     * 设置内容占坑
     *
     * @param publicTabId
     * @param appId
     * @param relationList
     * @return
     */
    DubboResult<Maila88BusinessMsgDto> configPosition(Long publicTabId, Long appId, List<Maila88PublicTabPositionTypeDto> relationList);

    /**
     * 取消内容占坑
     *
     * @param publicTabId
     * @param appId
     * @param relationType
     * @param relationId
     * @return
     */
    DubboResult<Boolean> removePosition(Long publicTabId, Long appId, Integer relationType, Long relationId);

    /**
     * 批量取消内容占坑
     * @param publicTabId
     * @param list
     * @return
     */
    DubboResult<Boolean> removePositionList(Long publicTabId, List<Maila88PublicTabRelationIdsAndTypeDto> list);
}
