package com.maila88.modules.tab.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.MailaCategoryTabGoodsDto;
import com.maila.biz.center.api.dto.MailaTabDto;
import com.maila88.modules.tab.dto.Maila88TabDto;
import com.maila88.modules.tab.dto.Maila88TabGoodsAndSpecialDto;

import java.util.List;
import java.util.Map;

/**
 * Created by sunchangji on 2017/4/19.
 */
@AdvancedFeignClient
public interface RemoteMaila88TabBackendService {

    /**
     * 新增
     *
     * @param maila88TabDto
     * @return
     */
    DubboResult<Long> insertMailaTab(Maila88TabDto maila88TabDto);

    /**
     * 更新
     *
     * @param maila88TabDto
     * @return
     */
    DubboResult<Boolean> updateMailaTab(Maila88TabDto maila88TabDto);

    /**
     * 更新tab启用禁用
     *
     * @param enable 1:启用，0:禁用
     * @param id
     * @return
     */
    DubboResult<Boolean> updateEnable(Integer enable, Long id);

    /**
     * 删除tab
     *
     * @param tabId
     * @return
     */
    DubboResult<Boolean> deleteMailaTabById(Long tabId);

    /**
     * 根据应用id查询tab
     *
     * @param appId 应用id
     * @return
     */
    DubboResult<List<Maila88TabDto>> selectAllEnableByAppId(Long appId);

    /**
     * 批量更新tab顺序
     *
     * @param tabIdList
     * @return
     */
    DubboResult<Boolean> batchUpdateTabPayload(List<Long> tabIdList);

    /**
     * 更新tab下商品或专场的顺序
     *
     * @param appId      应用id
     * @param tabId
     * @param idsStrList 专场或商品的id集合,形如:g35343,s8553
     *                   g开头是商品,s开头是专场
     * @return
     */
    DubboResult<Boolean> updateTabGoodsSpecialPayload(Long appId, Long tabId, List<String> idsStrList);

    /**
     * 查询应用下某一个tab下商品或者专场的列表数据
     *
     * @param appId
     * @param tabId
     * @param pageStart
     * @param pageSize
     * @return
     */
    DubboResult<List<Maila88TabGoodsAndSpecialDto>> selectGoodsSpecialByTabId(Long appId, Long tabId, Integer pageStart, Integer pageSize);

    /**
     * 查询应用下某一个tab下商品或者专场的列表数据量
     * @param appId
     * @param tabId
     * @return
     */
    DubboResult<Integer> countFindByAppIdAndTabId(Long appId, Long tabId);

    /**
     * 根据中间表id删除tab与商品专场中间表记录
     *
     * @param tabGoodsRelationId 商品专场中间表id
     * @return
     */
    DubboResult<Boolean> deleteRelationByRelationId(Long tabGoodsRelationId);

    /**
     * 删除tab下已下架商品或专场中间表记录
     *
     * @param appId 应用id
     * @param tabId
     * @return
     */
    DubboResult<Boolean> deleteByTabIdAndRelationStatus(Long appId, Long tabId);

    /**
     * 批量新增tab下商品或者专场关联关系
     *
     * @param appId       应用id
     * @param tabId
     * @param type        类型(2:商品,3:专场)
     * @param relationIds (type为2则为商品Id集合,为3则为专场id集合)
     * @return
     */
    DubboResult<Boolean> batchInsertTabGoodsRelation(Long appId, Long tabId, Integer type, List<Long> relationIds);

    /**
     * 批量添加一个商品到多个tab里
     *
     * @param goodsId   商品id
     * @param tabIdList tab id集合
     * @return
     */
    DubboResult<Boolean> batchInsertGoodsToTabIds(Long goodsId, List<Long> tabIdList);

    /**
     * 类目tab下的内容（目前只有商品）置顶
     *
     * @param appId      应用id
     * @param tabId      tabId
     * @param contentIds 置顶内容id字符串，例：1,2,3,4
     * @return
     */
    DubboResult<Boolean> categoryTabTop(Long appId, Long tabId, List<Long> contentIds);

    /**
     * 类目tab下的内容（目前只有商品）取消置顶
     *
     * @param appId      应用id
     * @param tabId      tabId
     * @param contentIds 置顶内容id字符串，例：1,2,3,4
     * @return
     */
    DubboResult<Boolean> categoryTabCancelTop(Long appId, Long tabId, List<Long> contentIds);

    /**
     * 查询类目tab下的商品列表
     *
     * @param appId    应用id
     * @param tabId    tabId
     * @param id       当前页最后一条数据的商品记录id
     * @param pageSize 每页条数
     * @return
     */
    DubboResult<List<MailaCategoryTabGoodsDto>> findCategoryGoodsList(Long appId, Long tabId, Long id, Integer pageSize);

    /**
     * 根据tab id和商品id查询该商品是否在该tab关联表中存在
     *
     * @param appId   麦啦应用id
     * @param tabId   tab id
     * @param goodsId 商品id
     * @return true:存在,false:不存在
     *
     * 已过时,不要再使用
     */
    DubboResult<Boolean> findByAppIdAndTabIdAndGoodsId(Long appId, Long tabId, Long goodsId);

    /**
     * 根据tab id和商品id集合查询该商品是否在该tab关联表中存在
     *
     * @param appId    麦啦应用id
     * @param tabId    tab id
     * @param goodsIds 商品id集合
     * @return 存在的商品id集合
     */
    DubboResult<List<Long>> findExistGoodsIdByTabIdAndGoodsIds(Long appId, Long tabId, List<Long> goodsIds);

     /**
     * 更新公共tab个性化占坑开关
     * @param tabId  tabid
     * @param switches  true:打开,false:关闭
     * @return
     */
     DubboResult<Boolean> updatePublicTabSwitches(Long tabId,Boolean switches);

     /**
     * 增加公共tab类型tab
     * @param maila88TabDto
     * @return
     */
     DubboResult<Long>  insertPublicTabType(Maila88TabDto maila88TabDto);

    /**
     * 查询所有普通tab数据,不包括类目tab和公共tab
     * @param appId  应用id
     * @return
     */
    DubboResult<List<MailaTabDto>> findAllOrdinaryTab(Long appId);

    /**
     * 切换公共排序方式
     * @param tabId  tabid
     * @param switches  true:开启自动化排序,false:开启公共排序
     * @return
     */
    DubboResult<Boolean> updatePublicTabAutoSort(Long tabId, Boolean switches);

    /**
     * 交换tab下两个数据顺序
     * @param id         主键id
     * @param anotherId  主键id
     * @return boolean
     */
    Boolean swopPayload(Long id, Long anotherId);

    /**
     * 获取商品id和tab名集合关系map
     * @param appId
     * @param goodsId
     * @return
     */
    Map<Long, List<String>> findgoodsIdAndTabTitlesMap(Long appId, List<Long> goodsId);
}
