package com.maila88.modules.tab.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.MailaCategoryTabGoodsDto;
import com.maila.biz.center.api.dto.MailaTabDto;
import com.maila.biz.center.api.dto.TabGoodsSpecialDto;
import com.maila88.modules.tab.dto.Maila88PublicTabContent4MobileDto;
import com.maila88.modules.tab.dto.Maila88TabContentQueryDto;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * Created by sunchangji on 2017/4/25.
 */
@AdvancedFeignClient
public interface RemoteMaila88TabService {
    /**
     * 根据应用id获取启用的tab列表数据
     *
     * @param appId 应用id
     * @return
     */
    DubboResult<List<MailaTabDto>> selectTabListByAppId(Long appId);

    /**
     * 获取tab下内容列表
     *
     * @param tabContentQueryDto
     * @return
     */
    DubboResult<List<TabGoodsSpecialDto>> findTabContentList(Maila88TabContentQueryDto tabContentQueryDto);

    /**
     * 根据应用id和tabId分页获取tab下已上架商品或专场数据
     *
     * @param appId     应用id
     * @param tabId
     * @param pageStart 第几页
     * @param pageSize  一页多少条
     * @return
     */
    DubboResult<List<TabGoodsSpecialDto>> selectTabGoodsSpecialByAppIdAndTabId(Long appId, Long tabId, Integer pageStart, Integer pageSize);

    /**
     * 获取类目tab下的商品列表
     *
     * @param appId    应用id
     * @param tabId    tab id
     * @param id       商品记录id
     * @param pageSize 每页数量
     * @return
     */
    DubboResult<List<MailaCategoryTabGoodsDto>> findCategoryGoodsList(Long appId, Long tabId, Long id, Integer pageSize);

    /**
     * 根据tab id查询tab
     * @param id
     * @return
     */
    DubboResult<MailaTabDto> findById(Long id);

    /**
     * 获取tab下商品或专场总个数
     *
     * @param appId 应用id
     * @param tabId tabId
     * @return int 总条数
     */
    DubboResult<Integer> findTabGoodsSpecialTotalCount(Long appId, Long tabId);


    /**
     * 获取公共tab下的商品列表
     *
     * @param appId    应用id
     * @param tabId    tab id
     * @param offset   偏移量
     * @param pageSize 每页数量
     * @return
     */
    DubboResult<List<Maila88PublicTabContent4MobileDto>> findPublicTabContent(Long appId, Long tabId, Integer offset, Integer pageSize);

    /**
     * 获取公共tab下的商品列表
     *
     * @param appId    应用id
     * @param tabId    tab id
     * @param id       商品记录id
     * @param pageSize 每页数量
     * @return
     *
     * 已过时,不要再使用
     */
    @RequestMapping("findPublicTabContent1")
    DubboResult<List<Maila88PublicTabContent4MobileDto>> findPublicTabContent(Long appId, Long tabId, Long id, Integer pageSize);

}
