package com.maila.biz.center.api.dto.query;

import java.io.Serializable;
import java.util.Date;

/**
 * 管理员后台第三方商品库筛选条件
 * @Author zhanghuifeng
 * @Date 18:56 2017/3/7
 */
public class MailaThirdpartyGoodsQryDto implements Serializable {
	private static final long serialVersionUID = -2974631657704286165L;
	/**
	 * 数据来源平台
	 */
	private Integer sourceType;

	/**
	 * 类目
	 */
	private Integer category;

	/**
	 * 活动计划类型(1.通用,2:定向,3:鹊桥，该字段作为优惠券商品拼接url类型依据)
	 */
	private Integer planType;

	/**
	 * 优惠券到期时间
	 */
	private Date couponTime;

	/**
	 * 商品状态(0:待入库 1:已入库,2:主库已存在)
	 */
	private Integer goodsStatus;

	/**
	 * 佣金比例
	 */
	private Integer commissionRate;

	/**
	 * 券后价下限(分)
	 */
	private Integer preferPriceDown;

	/**
	 * 券后价上限(分)
	 */
	private Integer preferPriceUp;

	/**
	 * 商品描述分
	 */
	private Integer dsr;

	/**
	 * 标题
	 */
	private String title;

	/**
	 * 审核人
	 */
	private String auditor;

	/**
	 *  偏移量
	 */
	private Integer offset;

	/**
	 * 每页条数
	 */
	private Integer pageSize;

	/**
	 * 排序类型
	 */
	private String sortType;

	/**
	 * 是否是top100
	 */
	private Boolean isTop;

	/**
	 * 是否是上新
	 */
	private Boolean isNewer;

	/**
	 * 折扣力度
	 */
	private Integer discountRate;

	/**
	 * 销量
	 */
	private Integer volume;

	/**
	 * 优惠券面额
	 */
	private Integer couponPrice;

	/**
	 * 活动类型
	 */
	private Integer activityType;

	public Integer getSourceType() {
		return sourceType;
	}

	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}

	public Integer getCategory() {
		return category;
	}

	public void setCategory(Integer category) {
		this.category = category;
	}

	public Integer getPlanType() {
		return planType;
	}

	public void setPlanType(Integer planType) {
		this.planType = planType;
	}

	public Date getCouponTime() {
		return couponTime;
	}

	public void setCouponTime(Date couponTime) {
		this.couponTime = couponTime;
	}

	public Integer getGoodsStatus() {
		return goodsStatus;
	}

	public void setGoodsStatus(Integer goodsStatus) {
		this.goodsStatus = goodsStatus;
	}

	public Integer getCommissionRate() {
		return commissionRate;
	}

	public void setCommissionRate(Integer commissionRate) {
		this.commissionRate = commissionRate;
	}

	public Integer getPreferPriceDown() {
		return preferPriceDown;
	}

	public void setPreferPriceDown(Integer preferPriceDown) {
		this.preferPriceDown = preferPriceDown;
	}

	public Integer getPreferPriceUp() {
		return preferPriceUp;
	}

	public void setPreferPriceUp(Integer preferPriceUp) {
		this.preferPriceUp = preferPriceUp;
	}

	public Integer getDsr() {
		return dsr;
	}

	public void setDsr(Integer dsr) {
		this.dsr = dsr;
	}

	public Integer getOffset() {
		return offset;
	}

	public void setOffset(Integer offset) {
		this.offset = offset;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getAuditor() {
		return auditor;
	}

	public void setAuditor(String auditor) {
		this.auditor = auditor;
	}

	public Boolean getTop() {
		return isTop;
	}

	public void setTop(Boolean top) {
		isTop = top;
	}

	public Boolean getNewer() {
		return isNewer;
	}

	public void setNewer(Boolean newer) {
		isNewer = newer;
	}

	public String getSortType() {
		return sortType;
	}

	public void setSortType(String sortType) {
		this.sortType = sortType;
	}

	public Integer getDiscountRate() {
		return discountRate;
	}

	public void setDiscountRate(Integer discountRate) {
		this.discountRate = discountRate;
	}

	public Integer getVolume() {
		return volume;
	}

	public void setVolume(Integer volume) {
		this.volume = volume;
	}

	public Integer getCouponPrice() {
		return couponPrice;
	}

	public void setCouponPrice(Integer couponPrice) {
		this.couponPrice = couponPrice;
	}

	public Integer getActivityType() {
		return activityType;
	}

	public void setActivityType(Integer activityType) {
		this.activityType = activityType;
	}
}
