package com.maila.biz.center.api.enums;

import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;

/**
 * 功能描述:
 * 商品活动计划类型(1.通用,2:定向,3:鹊桥，该字段作为优惠券商品拼接url类型依据)
 *
 * @author sunchangji
 * @date 2016/12/9
 */
public enum MailaGoodsPlanType {
	UNIVERSAL(1, "通用"), DIRECTIONAL(2, "定向"), DATING(3, "鹊桥"),MARKETING(4,"营销");

	private int type;
	private String typeName;

	MailaGoodsPlanType(int type, String typeName) {
		this.type = type;
		this.typeName = typeName;
	}

	/**
	 * 根据id获取名称
	 *
	 * @param type
	 * @return
	 */
	public static String getNameById(final int type) {
		Collection<MailaGoodsPlanType> result = Collections2.filter(Arrays.asList(MailaGoodsPlanType.values()), gs -> gs.getType() == type);
		return result.isEmpty() ? "" : result.iterator().next().getTypeName();
	}

	public int getType() {
		return type;
	}

	public String getTypeName() {
		return typeName;
	}

	/**
	 * 是计划商品类型
	 * @param id
	 * @return
     */
	public static boolean isGoodsPlanType(int id) {
		boolean flag = false;
		switch (id) {
			case 1:
			case 2:
			case 3:
				flag = true;
				break;
			default:
				break;
		}
		return flag;
	}
}
